/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.kyrptonaught.inventorysorter.InventoryHelper;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.commands.CommandTranslations;
import net.kyrptonaught.inventorysorter.network.PlayerSortPrevention;
import net.kyrptonaught.inventorysorter.permissions.CommandPermission;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class NoSortCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> rootCommand) {
        LiteralArgumentBuilder nosort = (LiteralArgumentBuilder)class_2170.method_9247((String)"nosort").requires(CommandPermission.require("nosort", 0));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(nosort.then(class_2170.method_9247((String)"add").executes(NoSortCommand::add))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(nosort.then(class_2170.method_9247((String)"remove").executes(NoSortCommand::remove))));
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(nosort.then(class_2170.method_9247((String)"list").executes(NoSortCommand::list))));
    }

    public static int add(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        PlayerSortPrevention playerSortPrevention = (PlayerSortPrevention)player.getAttachedOrCreate(InventorySorterMod.PLAYER_SORT_PREVENTION);
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            playerSortPrevention.preventSortForScreens().add(context.screenId().toString());
            player.setAttached(InventorySorterMod.PLAYER_SORT_PREVENTION, (Object)playerSortPrevention);
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.add.fail"), false);
            return 0;
        }
        playerSortPrevention.sync(player);
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.add.success"), false);
        return 1;
    }

    public static int remove(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        PlayerSortPrevention playerSortPrevention = (PlayerSortPrevention)player.getAttachedOrCreate(InventorySorterMod.PLAYER_SORT_PREVENTION);
        Boolean success = InventoryHelper.withTargetedScreenHandler(player, context -> {
            playerSortPrevention.preventSortForScreens().remove(context.screenId().toString());
            player.setAttached(InventorySorterMod.PLAYER_SORT_PREVENTION, (Object)playerSortPrevention);
            return true;
        });
        if (Boolean.FALSE.equals(success)) {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.remove.fail"), false);
            return 0;
        }
        playerSortPrevention.sync(player);
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43471((String)"inventorysorter.cmd.nosort.remove.success"), false);
        return 1;
    }

    public static int list(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        PlayerSortPrevention playerSortPrevention = (PlayerSortPrevention)player.getAttachedOrCreate(InventorySorterMod.PLAYER_SORT_PREVENTION);
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43469((String)"inventorysorter.cmd.nosort.list", (Object[])new Object[]{String.join((CharSequence)",", playerSortPrevention.preventSortForScreens())}), false);
        return 1;
    }
}

