/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.compat.sources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.compat.Compatibility;
import net.kyrptonaught.inventorysorter.compat.sources.CompatibilityLoader;
import net.minecraft.class_2960;

public class LocalLoader
implements CompatibilityLoader {
    private static final String DO_NOT_SORT_DATA = "data/inventorysorter/do-not-sort.json";
    private static final String HIDE_BUTTONS_DATA = "data/inventorysorter/hide-buttons.json";

    @Override
    public Set<class_2960> getPreventSort() {
        return this.load(DO_NOT_SORT_DATA);
    }

    @Override
    public Set<class_2960> getShouldHideSortButtons() {
        return this.load(HIDE_BUTTONS_DATA);
    }

    private Set<class_2960> load(String path) {
        InventorySorterMod.LOGGER.debug("Loading local compatibility data from: {}", (Object)path);
        Set<class_2960> identifiers = null;
        try (InputStream is = LocalLoader.class.getResourceAsStream(path);){
            if (is != null) {
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                identifiers = Compatibility.parseJson(reader);
            }
        }
        catch (IOException e) {
            InventorySorterMod.LOGGER.info("Could not find file: " + path + " in jar, creating empty list");
            throw new RuntimeException(e);
        }
        if (identifiers == null) {
            return Set.of();
        }
        return identifiers;
    }
}

