/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.io.Reader;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;

public class SchemaValidator {
    public static final String CONFIG_SCHEMA = "config-schema.json";
    public static final String REMOTE_CONFIG_SCHEMA = "config-remote-schema.json";
    public static final String STRING_ARRAY_SCHEMA = "string-array-schema.json";

    public static boolean isValidJsonObject(Reader jsonReader, String schemaResource, String sourceName) {
        return SchemaValidator.validate(schemaResource, sourceName, () -> {
            JsonElement json = JsonParser.parseReader((Reader)jsonReader);
            return new JSONObject(json.toString());
        });
    }

    public static boolean isValidJsonArray(Reader jsonReader, String schemaResource, String sourceName) {
        return SchemaValidator.validate(schemaResource, sourceName, () -> {
            JsonElement json = JsonParser.parseReader((Reader)jsonReader);
            return new JSONArray(json.toString());
        });
    }

    private static boolean validate(String schemaResource, String sourceName, JsonSupplier supplier) {
        boolean bl;
        block11: {
            InputStream schemaStream = SchemaValidator.class.getClassLoader().getResourceAsStream(schemaResource);
            try {
                if (schemaStream == null) {
                    throw new IllegalStateException("Schema not found: " + schemaResource);
                }
                JSONObject schemaObj = new JSONObject(new JSONTokener(schemaStream));
                Schema schema = SchemaLoader.load((JSONObject)schemaObj);
                Object parsedJson = supplier.get();
                schema.validate(parsedJson);
                bl = true;
                if (schemaStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (schemaStream != null) {
                        try {
                            schemaStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ValidationException e) {
                    InventorySorterMod.LOGGER.error("Validation error in {}:", (Object)sourceName);
                    InventorySorterMod.LOGGER.error(e.getErrorMessage());
                    e.getCausingExceptions().stream().map(ValidationException::getMessage).forEach(arg_0 -> ((Logger)InventorySorterMod.LOGGER).error(arg_0));
                    throw new RuntimeException(e);
                }
                catch (JsonSyntaxException e) {
                    InventorySorterMod.LOGGER.error("Invalid JSON syntax in {}: {}", (Object)sourceName, (Object)e.getCause().getMessage());
                    return false;
                }
                catch (Exception e) {
                    InventorySorterMod.LOGGER.error("Unexpected error validating {}: {}", (Object)sourceName, (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            schemaStream.close();
        }
        return bl;
    }

    private static interface JsonSupplier {
        public Object get() throws Exception;
    }
}

