/*
 * Decompiled with CFR 0.152.
 */
package com.ihatecsv.mineremote;

import com.google.gson.JsonObject;
import com.ihatecsv.mineremote.util.Config;
import com.ihatecsv.mineremote.util.ImageRenderer;
import com.ihatecsv.mineremote.util.Inventory;
import com.ihatecsv.mineremote.util.WebServer;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ClientMain
implements ClientModInitializer {
    private static final String HTML_PATH = "/assets/mineremote/index.html";
    private static final Config C = Config.get();
    private static final int OUTSIDE = -999;
    private static final Map<String, byte[]> ICON_CACHE = new ConcurrentHashMap<String, byte[]>();
    private static final List<SSEClient> SSE_CLIENTS = new CopyOnWriteArrayList<SSEClient>();
    private static final ScheduledExecutorService PUSH_EXEC = Executors.newSingleThreadScheduledExecutor();
    private static volatile JsonObject LAST_INV = null;

    public void onInitializeClient() {
        class_156.method_18349().execute(ClientMain::startHttp);
    }

    private static void startHttp() {
        try {
            HttpServer s = HttpServer.create(new InetSocketAddress(ClientMain.C.bindAddress, ClientMain.C.port), 0);
            s.createContext("/", ClientMain::root);
            s.createContext("/api/inventory", ClientMain::inventory);
            s.createContext("/api/click", ClientMain::click);
            s.createContext("/api/toss", ClientMain::toss);
            s.createContext("/api/command", ClientMain::command);
            s.createContext("/api/events", ClientMain::events);
            s.createContext("/icon", ClientMain::icon);
            s.setExecutor(Executors.newSingleThreadExecutor());
            s.start();
            PUSH_EXEC.scheduleAtFixedRate(ClientMain::pushUpdates, 0L, ClientMain.C.updateMs, TimeUnit.MILLISECONDS);
            System.out.println("[MineRemote] http://" + ClientMain.C.bindAddress + ":" + ClientMain.C.port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void root(HttpExchange ex) throws IOException {
        if (!ex.getRequestMethod().equals("GET")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        try (InputStream in = ClientMain.class.getResourceAsStream(HTML_PATH);){
            if (in == null) {
                WebServer.respond(ex, 404, "index.html not found");
                return;
            }
            byte[] data = in.readAllBytes();
            ex.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
            ex.sendResponseHeaders(200, data.length);
            try (OutputStream out = ex.getResponseBody();){
                out.write(data);
            }
        }
    }

    private static void inventory(HttpExchange ex) throws IOException {
        if (!ex.getRequestMethod().equals("GET")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        WebServer.respondJson(ex, Inventory.buildInvJson());
    }

    private static void click(HttpExchange ex) throws IOException {
        JsonObject reply;
        if (!ex.getRequestMethod().equals("POST")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        JsonObject body = WebServer.readJsonBody(ex);
        if (body == null || !body.has("slot")) {
            WebServer.respond(ex, 400, "bad body");
            return;
        }
        int invSlot = body.get("slot").getAsInt();
        int mouseButton = body.has("button") ? body.get("button").getAsInt() : 0;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            WebServer.respond(ex, 500, "no player");
            return;
        }
        int containerSlot = Inventory.invToContainer(invSlot);
        if (containerSlot < 0) {
            WebServer.respond(ex, 400, "bad slot");
            return;
        }
        LAST_INV = reply = WebServer.await(() -> {
            if (mc.field_1761 != null) {
                mc.field_1761.method_2906(mc.field_1724.field_7512.field_7763, containerSlot, mouseButton, class_1713.field_7790, (class_1657)mc.field_1724);
            }
            return Inventory.buildInvJson();
        });
        WebServer.respondJson(ex, reply);
    }

    private static void toss(HttpExchange ex) throws IOException {
        JsonObject reply;
        if (!ex.getRequestMethod().equals("POST")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            WebServer.respond(ex, 500, "no player");
            return;
        }
        LAST_INV = reply = WebServer.await(() -> {
            if (mc.field_1761 != null) {
                mc.field_1761.method_2906(mc.field_1724.field_7512.field_7763, -999, 0, class_1713.field_7790, (class_1657)mc.field_1724);
            }
            return Inventory.buildInvJson();
        });
        WebServer.respondJson(ex, reply);
    }

    private static void command(HttpExchange ex) throws IOException {
        JsonObject reply;
        if (!Config.get().allowCommands) {
            WebServer.respond(ex, 403, "command endpoint disabled");
            return;
        }
        if (!ex.getRequestMethod().equals("POST")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        JsonObject body = WebServer.readJsonBody(ex);
        if (body == null || !body.has("cmd")) {
            WebServer.respond(ex, 400, "bad body");
            return;
        }
        String cmd = body.get("cmd").getAsString();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            WebServer.respond(ex, 500, "no player");
            return;
        }
        LAST_INV = reply = WebServer.await(() -> {
            mc.field_1724.field_3944.method_45730(cmd);
            return Inventory.buildInvJson();
        });
        WebServer.respondJson(ex, reply);
    }

    private static void icon(HttpExchange ex) throws IOException {
        if (!ex.getRequestMethod().equals("GET")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        String raw = ex.getRequestURI().getPath().substring("/icon/".length());
        if (!raw.endsWith(".png") || !raw.contains("/")) {
            WebServer.respond(ex, 400, "");
            return;
        }
        String id = (raw = raw.substring(0, raw.length() - 4)).replace('/', ':');
        byte[] png = ICON_CACHE.computeIfAbsent(id, key -> WebServer.await(() -> ClientMain.renderIconPng(key)));
        if (png == null) {
            WebServer.respond(ex, 404, "");
            return;
        }
        ex.getResponseHeaders().add("Content-Type", "image/png");
        ex.sendResponseHeaders(200, png.length);
        try (OutputStream out = ex.getResponseBody();){
            out.write(png);
        }
    }

    private static void events(HttpExchange ex) throws IOException {
        if (!ex.getRequestMethod().equals("GET")) {
            WebServer.respond(ex, 405, "");
            return;
        }
        ex.getResponseHeaders().add("Content-Type", "text/event-stream");
        ex.getResponseHeaders().add("Cache-Control", "no-cache");
        ex.getResponseHeaders().add("Connection", "keep-alive");
        ex.sendResponseHeaders(200, 0L);
        SSEClient client = new SSEClient(ex);
        SSE_CLIENTS.add(client);
        JsonObject init = WebServer.await(Inventory::buildInvJson);
        if (init != null) {
            LAST_INV = init;
            client.send(("data: " + init.toString() + "\n\n").getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void pushUpdates() {
        JsonObject cur = WebServer.await(Inventory::buildInvJson);
        if (cur == null) {
            return;
        }
        if (LAST_INV != null && LAST_INV.equals((Object)cur)) {
            return;
        }
        byte[] msg = ("data: " + cur.toString() + "\n\n").getBytes(StandardCharsets.UTF_8);
        for (SSEClient c : SSE_CLIENTS) {
            try {
                c.send(msg);
            }
            catch (IOException e) {
                c.close();
                SSE_CLIENTS.remove(c);
            }
        }
        LAST_INV = cur;
    }

    private static byte[] renderIconPng(String itemId) {
        class_1792 item;
        if (ClientMain.C.debug) {
            System.out.println("renderIconPng \u25b8 request for " + itemId);
        }
        if ((item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId))) == null || item == class_1802.field_8162) {
            System.out.println("renderIconPng \u2716 unknown item id " + itemId);
            return null;
        }
        class_1799 stack = new class_1799((class_1935)item);
        ImageRenderer ir = new ImageRenderer(Config.get().iconSizePx);
        try {
            Path tmp = Files.createTempFile("icon_", ".png", new FileAttribute[0]);
            ir.captureRender(tmp, () -> {
                class_310 mc = class_310.method_1551();
                class_332 d = new class_332(mc, mc.method_22940().method_23000());
                d.method_51427(stack, 0, 0);
                d.method_51452();
            });
            byte[] data = Files.readAllBytes(tmp);
            Files.deleteIfExists(tmp);
            if (ClientMain.C.debug) {
                System.out.println("renderIconPng \u2714 encoded " + data.length + " bytes");
            }
            byte[] byArray = data;
            ir.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ir.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("renderIconPng \u2716 " + e.getMessage());
                return null;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class SSEClient {
        final HttpExchange ex;
        final OutputStream out;

        SSEClient(HttpExchange ex) {
            this.ex = ex;
            this.out = ex.getResponseBody();
        }

        void send(byte[] bytes) throws IOException {
            this.out.write(bytes);
            this.out.flush();
        }

        void close() {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ex.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

