/*
 * Decompiled with CFR 0.152.
 */
package com.ihatecsv.mineremote.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = Path.of("config", "mineremote.json");
    public int port = 8765;
    public String bindAddress = "127.0.0.1";
    public int updateMs = 200;
    public int iconSizePx = 256;
    public boolean allowCommands = true;
    public boolean debug = false;
    private static Config INSTANCE;

    public static Config get() {
        return INSTANCE == null ? Config.load() : INSTANCE;
    }

    private static Config load() {
        try {
            if (Files.notExists(FILE, new LinkOption[0])) {
                Config.save(new Config());
            }
            JsonObject json = (JsonObject)GSON.fromJson(Files.readString(FILE), JsonObject.class);
            INSTANCE = (Config)GSON.fromJson((JsonElement)json, Config.class);
        }
        catch (Exception e) {
            System.err.println("[MineRemote] Failed to load config, using defaults: " + e);
            INSTANCE = new Config();
        }
        return INSTANCE;
    }

    private static void save(Config cfg) throws IOException {
        Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
        Files.writeString(FILE, (CharSequence)GSON.toJson((Object)cfg), new OpenOption[0]);
    }
}

