/*
 * Decompiled with CFR 0.152.
 */
package com.ihatecsv.mineremote.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class WebServer {
    private static final long AWAIT_MS = 200L;
    private static final Gson GSON = new Gson();

    public static <T> T await(Callable<T> task) {
        CompletableFuture fut = new CompletableFuture();
        class_310.method_1551().execute(() -> {
            try {
                fut.complete(task.call());
            }
            catch (Exception e) {
                fut.complete(null);
            }
        });
        try {
            return fut.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonObject readJsonBody(HttpExchange ex) {
        JsonObject jsonObject;
        InputStreamReader r = new InputStreamReader(ex.getRequestBody(), StandardCharsets.UTF_8);
        try {
            jsonObject = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        r.close();
        return jsonObject;
    }

    public static void respondJson(HttpExchange ex, JsonObject obj) throws IOException {
        byte[] data = obj.toString().getBytes(StandardCharsets.UTF_8);
        ex.getResponseHeaders().add("Content-Type", "application/json");
        ex.sendResponseHeaders(200, data.length);
        try (OutputStream out = ex.getResponseBody();){
            out.write(data);
        }
    }

    public static void respond(HttpExchange ex, int code, String txt) throws IOException {
        byte[] data = txt.getBytes(StandardCharsets.UTF_8);
        ex.sendResponseHeaders(code, data.length);
        try (OutputStream out = ex.getResponseBody();){
            out.write(data);
        }
    }
}

