/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmparallelpipes.compat.copycats;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.content.copycat.fluid_pipe.CopycatFluidPipeBlock;
import com.copycatsplus.copycats.content.copycat.fluid_pipe.CopycatFluidPipeBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.krei.cmparallelpipes.LockedPipeMarker;
import com.krei.cmparallelpipes.compat.copycats.CopycatsPlusCompat;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class LockedCopycatFluidPipeBlock
extends CopycatFluidPipeBlock
implements LockedPipeMarker {
    public LockedCopycatFluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CopycatsPlusCompat.LOCKED_COPYCAT_FLUID_PIPE_BLOCK_ENTITY.get();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return CCBlocks.COPYCAT_FLUID_PIPE.asStack();
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (LockedCopycatFluidPipeBlock.isOpenAt((BlockState)state, (Direction)direction) && neighbourState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            world.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
        }
        return state;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos pos;
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockEntity blockEntity = world.getBlockEntity(pos = context.getClickedPos());
        if (blockEntity instanceof CopycatFluidPipeBlockEntity) {
            CopycatFluidPipeBlockEntity be = (CopycatFluidPipeBlockEntity)blockEntity;
            if (be.getConsumedItem().getItem().equals(Items.AIR)) {
                if (world.isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
                BlockState equivalentPipe = EncasedPipeBlock.transferSixWayProperties((BlockState)state, (BlockState)CCBlocks.COPYCAT_FLUID_PIPE.getDefaultState());
                Direction firstFound = Direction.UP;
                for (Direction d : Iterate.directions) {
                    if (!((Boolean)state.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) continue;
                    firstFound = d;
                    break;
                }
                FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
                world.setBlockAndUpdate(pos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(equivalentPipe, firstFound, null, (BlockAndTintGetter)world, pos));
                FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
                return InteractionResult.SUCCESS;
            }
            ItemStack consumedItem = be.getConsumedItem();
            if (!be.hasCustomMaterial()) {
                return InteractionResult.PASS;
            }
            Player player = context.getPlayer();
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(consumedItem);
            }
            context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)ICopycatBlock.getMaterial((BlockGetter)context.getLevel(), (BlockPos)context.getClickedPos())));
            be.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
            be.setConsumedItem(ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState createBlockStateFromFluidPipe(BlockState blockState) {
        return LockedCopycatFluidPipeBlock.transferFluidPipeProperties(blockState, this.defaultBlockState());
    }

    public static BlockState transferFluidPipeProperties(BlockState from, BlockState to) {
        for (Direction d : Iterate.directions) {
            BooleanProperty property = (BooleanProperty)PROPERTY_BY_DIRECTION.get(d);
            to = (BlockState)to.setValue((Property)property, (Comparable)((Boolean)from.getValue((Property)property)));
        }
        BooleanProperty property = BlockStateProperties.WATERLOGGED;
        to = (BlockState)to.setValue((Property)property, (Comparable)((Boolean)from.getValue((Property)property)));
        return to;
    }

    public static void lockPipe(Level level, BlockPos pos) {
        CopycatFluidPipeBlockEntity x;
        CopycatFluidPipeBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CopycatFluidPipeBlockEntity copycatFluidPipeBlockEntity = be = blockEntity instanceof CopycatFluidPipeBlockEntity ? (x = (CopycatFluidPipeBlockEntity)blockEntity) : null;
        if (be == null) {
            return;
        }
        ItemStack itemStack = be.getConsumedItem();
        BlockState blockState = be.getMaterial();
        be.setConsumedItem(ItemStack.EMPTY);
        be.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
        FluidTransportBehaviour.cacheFlows((LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, ((LockedCopycatFluidPipeBlock)CopycatsPlusCompat.LOCKED_COPYCAT_FLUID_PIPE_BLOCK.get()).createBlockStateFromFluidPipe(level.getBlockState(pos)));
        FluidTransportBehaviour.loadFlows((LevelAccessor)level, (BlockPos)pos);
        LockedCopycatFluidPipeBlock.playLockingSound(level, pos);
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof CopycatFluidPipeBlockEntity) {
            CopycatFluidPipeBlockEntity nbe = (CopycatFluidPipeBlockEntity)blockEntity2;
            nbe.setConsumedItem(itemStack);
            nbe.setMaterial(blockState);
        }
    }

    public static void playLockingSound(Level level, BlockPos pos) {
        BlockState newState = level.getBlockState(pos);
        SoundType soundType = newState.getSoundType();
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }
}

