/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmparallelpipes;

import com.krei.cmparallelpipes.LockedPipeMarker;
import com.krei.cmparallelpipes.ParallelPipes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class LockedFluidPipeBlock
extends FluidPipeBlock
implements LockedPipeMarker {
    public LockedFluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ParallelPipes.LOCKED_FLUID_PIPE_BLOCK_ENTITY.get();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return AllBlocks.FLUID_PIPE.asStack();
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (LockedFluidPipeBlock.isOpenAt((BlockState)state, (Direction)direction) && neighbourState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            world.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
        }
        return state;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        BlockState equivalentPipe = EncasedPipeBlock.transferSixWayProperties((BlockState)state, (BlockState)AllBlocks.FLUID_PIPE.getDefaultState());
        Direction firstFound = Direction.UP;
        for (Direction d : Iterate.directions) {
            if (!((Boolean)state.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) continue;
            firstFound = d;
            break;
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        world.setBlockAndUpdate(pos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(equivalentPipe, firstFound, null, (BlockAndTintGetter)world, pos));
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState createBlockStateFromFluidPipe(BlockState blockState) {
        return LockedFluidPipeBlock.transferFluidPipeProperties(blockState, this.defaultBlockState());
    }

    public static BlockState transferFluidPipeProperties(BlockState from, BlockState to) {
        for (Direction d : Iterate.directions) {
            BooleanProperty property = (BooleanProperty)PROPERTY_BY_DIRECTION.get(d);
            to = (BlockState)to.setValue((Property)property, (Comparable)((Boolean)from.getValue((Property)property)));
        }
        BooleanProperty property = BlockStateProperties.WATERLOGGED;
        to = (BlockState)to.setValue((Property)property, (Comparable)((Boolean)from.getValue((Property)property)));
        return to;
    }

    public static void lockPipe(Level level, BlockPos pos) {
        FluidTransportBehaviour.cacheFlows((LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, ((LockedFluidPipeBlock)ParallelPipes.LOCKED_FLUID_PIPE_BLOCK.get()).createBlockStateFromFluidPipe(level.getBlockState(pos)));
        FluidTransportBehaviour.loadFlows((LevelAccessor)level, (BlockPos)pos);
        LockedFluidPipeBlock.playLockingSound(level, pos);
    }

    public static void playLockingSound(Level level, BlockPos pos) {
        BlockState newState = level.getBlockState(pos);
        SoundType soundType = newState.getSoundType();
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }
}

