/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios;

import java.util.HashMap;
import java.util.Map;
import net.luckystudios.Config;
import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.ModCreativeModeTabs;
import net.luckystudios.items.ModItems;
import net.luckystudios.items.armor.ModArmorMaterials;
import net.luckystudios.keybinds.HelmetTogglePacket;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="luckysarmory")
public class LuckysArmory {
    public static final String MOD_ID = "luckysarmory";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"luckysarmory");
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();

    public LuckysArmory(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModDataComponents.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(ModCreativeModeTabs::addVanillaCreative);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LuckysArmory.addNetworkMessage(HelmetTogglePacket.TYPE, HelmetTogglePacket.STREAM_CODEC, HelmetTogglePacket::handleData);
        event.enqueueWork(() -> {
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_IRON_HELMET.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_IRON_CHESTPLATE.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_IRON_LEGGINGS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_IRON_BOOTS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_GOLDEN_HELMET.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_GOLDEN_CHESTPLATE.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_GOLDEN_LEGGINGS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_GOLDEN_BOOTS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_DIAMOND_HELMET.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_DIAMOND_CHESTPLATE.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_DIAMOND_LEGGINGS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_DIAMOND_BOOTS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_NETHERITE_HELMET.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_NETHERITE_CHESTPLATE.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_NETHERITE_LEGGINGS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
            CauldronInteraction.WATER.map().put((Item)ModItems.HEAVY_NETHERITE_BOOTS.get(), ModArmorMaterials.DYED_ARMOR_ITEM);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

