/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Map;
import net.luckystudios.Config;
import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.ModItems;
import net.luckystudios.keybinds.TestModKeyMappings;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public class MyClientModEvents {
    private static final Map<Item, ResourceLocation> HELMET_OVERLAYS = Map.of((Item)ModItems.HEAVY_IRON_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/misc/iron_helmet_overlay.png"), (Item)ModItems.HEAVY_GOLDEN_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/misc/golden_helmet_overlay.png"), (Item)ModItems.HEAVY_DIAMOND_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/misc/diamond_helmet_overlay.png"), (Item)ModItems.HEAVY_NETHERITE_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/misc/netherite_helmet_overlay.png"));

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void renderHelmetOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.options.getCameraType() != CameraType.FIRST_PERSON) {
            return;
        }
        if (!Config.helmetOverlay) {
            return;
        }
        ItemStack helmetStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmetStack.isEmpty()) {
            return;
        }
        Item helmetItem = helmetStack.getItem();
        if (!helmetStack.has(ModDataComponents.OPENED)) {
            return;
        }
        int screenWidth = event.getGuiGraphics().guiWidth();
        int screenHeight = event.getGuiGraphics().guiHeight();
        if (!Boolean.TRUE.equals(helmetStack.get(ModDataComponents.OPENED))) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (MyClientModEvents.getHelmetOverlayTexture(helmetItem) == null) {
                return;
            }
            event.getGuiGraphics().blit(MyClientModEvents.getHelmetOverlayTexture(helmetItem), 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        String message = "[" + TestModKeyMappings.getKeyName(TestModKeyMappings.TOGGLE_HELMET) + "]";
        int y = screenHeight - 15;
        int textX = screenWidth / 2 + 120;
        int iconX = textX - 20;
        int iconY = y - 4;
        event.getGuiGraphics().renderItem(helmetStack, iconX, iconY);
        event.getGuiGraphics().drawString(mc.font, message, textX, y, Color.ORANGE.getRGB());
    }

    private static ResourceLocation getHelmetOverlayTexture(Item helmet) {
        return HELMET_OVERLAYS.get(helmet);
    }
}

