/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.datagen;

import java.util.concurrent.CompletableFuture;
import net.luckystudios.datagen.types.ModAdvancements;
import net.luckystudios.datagen.types.ModBlockStateProvider;
import net.luckystudios.datagen.types.ModBlockTagProvider;
import net.luckystudios.datagen.types.ModDataMapProvider;
import net.luckystudios.datagen.types.ModItemModelProvider;
import net.luckystudios.datagen.types.ModItemTagProvider;
import net.luckystudios.datagen.types.ModRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="luckysarmory", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancements(packOutput, lookupProvider, existingFileHelper));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
    }
}

