/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.datagen.types;

import java.util.LinkedHashMap;
import net.luckystudios.items.ModItems;
import net.luckystudios.items.armor.HeavyArmorItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private ResourceLocation HEAVY_CHESTPLATE_DYE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"item/heavy_chestplate_dye_overlay");
    private ResourceLocation HEAVY_LEGGINGS_DYE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"item/heavy_leggings_dye_overlay");
    private ResourceLocation HEAVY_BOOTS_DYE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"item/heavy_boots_dye_overlay");
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "luckysarmory", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.LIGHT_IRON_CHESTPLATE.get());
        this.basicItem((Item)ModItems.LIGHT_IRON_LEGGINGS.get());
        this.basicItem((Item)ModItems.LIGHT_GOLDEN_CHESTPLATE.get());
        this.basicItem((Item)ModItems.LIGHT_GOLDEN_LEGGINGS.get());
        this.basicItem((Item)ModItems.LIGHT_DIAMOND_CHESTPLATE.get());
        this.basicItem((Item)ModItems.LIGHT_DIAMOND_LEGGINGS.get());
        this.basicItem((Item)ModItems.LIGHT_NETHERITE_CHESTPLATE.get());
        this.basicItem((Item)ModItems.LIGHT_NETHERITE_LEGGINGS.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_iron_helmet_opened", "item/generated")).texture("layer0", "luckysarmory:item/heavy_iron_helmet_opened")).texture("layer1", "luckysarmory:item/heavy_iron_helmet_dye_overlay");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_iron_helmet", "item/generated")).texture("layer0", "luckysarmory:item/heavy_iron_helmet")).texture("layer1", "luckysarmory:item/heavy_iron_helmet_dye_overlay")).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"opened"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/heavy_iron_helmet_opened"))).end();
        this.trimmedArmorItem(ModItems.HEAVY_IRON_CHESTPLATE, this.HEAVY_CHESTPLATE_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_IRON_LEGGINGS, this.HEAVY_LEGGINGS_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_IRON_BOOTS, this.HEAVY_BOOTS_DYE_OVERLAY);
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_golden_helmet_opened", "item/generated")).texture("layer0", "luckysarmory:item/heavy_golden_helmet_opened")).texture("layer1", "luckysarmory:item/heavy_golden_helmet_dye_overlay");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_golden_helmet", "item/generated")).texture("layer0", "luckysarmory:item/heavy_golden_helmet")).texture("layer1", "luckysarmory:item/heavy_golden_helmet_dye_overlay")).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"opened"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/heavy_golden_helmet_opened"))).end();
        this.trimmedArmorItem(ModItems.HEAVY_GOLDEN_CHESTPLATE, this.HEAVY_CHESTPLATE_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_GOLDEN_LEGGINGS, this.HEAVY_LEGGINGS_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_GOLDEN_BOOTS, this.HEAVY_BOOTS_DYE_OVERLAY);
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_diamond_helmet_opened", "item/generated")).texture("layer0", "luckysarmory:item/heavy_diamond_helmet_opened")).texture("layer1", "luckysarmory:item/heavy_diamond_helmet_opened_dye_overlay");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_diamond_helmet", "item/generated")).texture("layer0", "luckysarmory:item/heavy_diamond_helmet")).texture("layer1", "luckysarmory:item/heavy_diamond_helmet_dye_overlay")).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"opened"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/heavy_diamond_helmet_opened"))).end();
        this.trimmedArmorItem(ModItems.HEAVY_DIAMOND_CHESTPLATE, this.HEAVY_CHESTPLATE_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_DIAMOND_LEGGINGS, this.HEAVY_LEGGINGS_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_DIAMOND_BOOTS, this.HEAVY_BOOTS_DYE_OVERLAY);
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_netherite_helmet_opened", "item/generated")).texture("layer0", "luckysarmory:item/heavy_netherite_helmet_opened")).texture("layer1", "luckysarmory:item/heavy_netherite_helmet_opened_dye_overlay");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("heavy_netherite_helmet", "item/generated")).texture("layer0", "luckysarmory:item/heavy_netherite_helmet")).texture("layer1", "luckysarmory:item/heavy_netherite_helmet_dye_overlay")).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"opened"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/heavy_netherite_helmet_opened"))).end();
        this.trimmedArmorItem(ModItems.HEAVY_NETHERITE_CHESTPLATE, this.HEAVY_CHESTPLATE_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_NETHERITE_LEGGINGS, this.HEAVY_LEGGINGS_DYE_OVERLAY);
        this.trimmedArmorItem(ModItems.HEAVY_NETHERITE_BOOTS, this.HEAVY_BOOTS_DYE_OVERLAY);
    }

    private void trimmedArmorItem(DeferredItem<HeavyArmorItem> itemDeferredItem, ResourceLocation overlayTexture) {
        String MOD_ID = "luckysarmory";
        Object object = itemDeferredItem.get();
        if (object instanceof HeavyArmorItem) {
            HeavyArmorItem armorItem = (HeavyArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", overlayTexture)).texture("layer2", trimResLoc);
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", this.modLoc("item/" + ModItemModelProvider.itemName((Item)itemDeferredItem.get())).toString())).texture("layer1", overlayTexture);
            });
        }
    }

    private void registerDyedArmorItem(Item item, ResourceLocation overlayTexture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ModItemModelProvider.itemName(item), "item/generated")).texture("layer0", this.modLoc("item/" + ModItemModelProvider.itemName(item)).toString())).texture("layer1", overlayTexture);
    }

    private static String itemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

