/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.events;

import net.luckystudios.MyClientModEvents;
import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.ModItems;
import net.luckystudios.items.armor.HeavyArmorItem;
import net.luckystudios.items.armor.models.HeavyBoots;
import net.luckystudios.items.armor.models.HeavyChestplate;
import net.luckystudios.items.armor.models.HeavyDiamondHelmet;
import net.luckystudios.items.armor.models.HeavyGoldenHelmet;
import net.luckystudios.items.armor.models.HeavyIronHelmet;
import net.luckystudios.items.armor.models.HeavyLeggings;
import net.luckystudios.items.armor.models.HeavyNetheriteHelmet;
import net.luckystudios.items.armor.models.LightChestplate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="luckysarmory", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(MyClientModEvents::renderHelmetOverlay);
        ModClientEvents.registerHelmetPredicate((Item)ModItems.HEAVY_IRON_HELMET.get());
        ModClientEvents.registerHelmetPredicate((Item)ModItems.HEAVY_GOLDEN_HELMET.get());
        ModClientEvents.registerHelmetPredicate((Item)ModItems.HEAVY_DIAMOND_HELMET.get());
        ModClientEvents.registerHelmetPredicate((Item)ModItems.HEAVY_NETHERITE_HELMET.get());
    }

    private static void registerHelmetPredicate(Item heavyHelmetItem) {
        ItemProperties.register((Item)heavyHelmetItem, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"opened"), (stack, clientLevel, livingEntity, num) -> HeavyArmorItem.getFullnessDisplay(stack));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ModClientEvents.renderItemColor(event, -6265536, new ItemLike[]{ModItems.HEAVY_IRON_HELMET, ModItems.HEAVY_IRON_CHESTPLATE, ModItems.HEAVY_IRON_LEGGINGS, ModItems.HEAVY_IRON_BOOTS});
        ModClientEvents.renderItemColor(event, DyeColor.RED.getTextureDiffuseColor(), new ItemLike[]{ModItems.HEAVY_GOLDEN_HELMET, ModItems.HEAVY_GOLDEN_CHESTPLATE, ModItems.HEAVY_GOLDEN_LEGGINGS, ModItems.HEAVY_GOLDEN_BOOTS});
        ModClientEvents.renderItemColor(event, DyeColor.PURPLE.getTextureDiffuseColor(), new ItemLike[]{ModItems.HEAVY_DIAMOND_HELMET, ModItems.HEAVY_DIAMOND_CHESTPLATE, ModItems.HEAVY_DIAMOND_LEGGINGS, ModItems.HEAVY_DIAMOND_BOOTS});
        ModClientEvents.renderItemColor(event, DyeColor.BLACK.getTextureDiffuseColor(), new ItemLike[]{ModItems.HEAVY_NETHERITE_HELMET, ModItems.HEAVY_NETHERITE_CHESTPLATE, ModItems.HEAVY_NETHERITE_LEGGINGS, ModItems.HEAVY_NETHERITE_BOOTS});
    }

    private static void renderItemColor(RegisterColorHandlersEvent.Item event, int color, ItemLike ... items) {
        event.register((stack, layer) -> {
            if (layer != 1) {
                return -1;
            }
            DyedItemColor dyedColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
            if (dyedColor == null) {
                return color;
            }
            int rgb = dyedColor.rgb();
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = Math.min((int)((float)r * 1.2f), 255);
            g = Math.min((int)((float)g * 1.2f), 255);
            b = Math.min((int)((float)b * 1.2f), 255);
            int boostedRgb = r << 16 | g << 8 | b;
            return FastColor.ARGB32.opaque((int)boostedRgb);
        }, items);
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        ModClientEvents.registerArmorModel(event, (Item)ModItems.LIGHT_IRON_CHESTPLATE.get(), LightChestplate.LAYER_LOCATION);
        ModClientEvents.registerArmorModel(event, (Item)ModItems.LIGHT_GOLDEN_CHESTPLATE.get(), LightChestplate.LAYER_LOCATION);
        ModClientEvents.registerArmorModel(event, (Item)ModItems.LIGHT_DIAMOND_CHESTPLATE.get(), LightChestplate.LAYER_LOCATION);
        ModClientEvents.registerArmorModel(event, (Item)ModItems.LIGHT_NETHERITE_CHESTPLATE.get(), LightChestplate.LAYER_LOCATION);
        ModClientEvents.registerHeavyIronHelmetModel(event, (Item)ModItems.HEAVY_IRON_HELMET.get(), DyeColor.WHITE.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_IRON_CHESTPLATE.get(), HeavyChestplate.LAYER_LOCATION, -6265536);
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_IRON_LEGGINGS.get(), HeavyLeggings.LAYER_LOCATION, -6265536);
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_IRON_BOOTS.get(), HeavyBoots.LAYER_LOCATION, -6265536);
        ModClientEvents.registerHeavyGoldenHelmetModel(event, (Item)ModItems.HEAVY_GOLDEN_HELMET.get(), DyeColor.RED.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_GOLDEN_CHESTPLATE.get(), HeavyChestplate.LAYER_LOCATION, DyeColor.RED.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_GOLDEN_LEGGINGS.get(), HeavyLeggings.LAYER_LOCATION, DyeColor.RED.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_GOLDEN_BOOTS.get(), HeavyBoots.LAYER_LOCATION, DyeColor.RED.getTextureDiffuseColor());
        ModClientEvents.registerHeavyDiamondHelmetModel(event, (Item)ModItems.HEAVY_DIAMOND_HELMET.get(), DyeColor.PURPLE.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_DIAMOND_CHESTPLATE.get(), HeavyChestplate.LAYER_LOCATION, DyeColor.PURPLE.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_DIAMOND_LEGGINGS.get(), HeavyLeggings.LAYER_LOCATION, DyeColor.PURPLE.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_DIAMOND_BOOTS.get(), HeavyBoots.LAYER_LOCATION, DyeColor.PURPLE.getTextureDiffuseColor());
        ModClientEvents.registerHeavyNetheriteHelmetModel(event, (Item)ModItems.HEAVY_NETHERITE_HELMET.get(), DyeColor.BLACK.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_NETHERITE_CHESTPLATE.get(), HeavyChestplate.LAYER_LOCATION, DyeColor.BLACK.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_NETHERITE_LEGGINGS.get(), HeavyLeggings.LAYER_LOCATION, DyeColor.BLACK.getTextureDiffuseColor());
        ModClientEvents.registerDyedArmorModel(event, (Item)ModItems.HEAVY_NETHERITE_BOOTS.get(), HeavyBoots.LAYER_LOCATION, DyeColor.BLACK.getTextureDiffuseColor());
    }

    private static void registerArmorModel(RegisterClientExtensionsEvent event, Item item, final ModelLayerLocation layer) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(layer);
                return new HumanoidModel(part);
            }
        }, new Item[]{item});
    }

    private static void registerDyedArmorModel(RegisterClientExtensionsEvent event, Item item, final ModelLayerLocation layer, final int defaultColor) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public int getDefaultDyeColor(ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)defaultColor)) : -1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(layer);
                return new HumanoidModel(part);
            }
        }, new Item[]{item});
    }

    private static void registerHeavyIronHelmetModel(RegisterClientExtensionsEvent event, Item item, final int defaultColor) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public void setupModelAnimations(LivingEntity entity, ItemStack stack, EquipmentSlot slot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                if (model instanceof HeavyIronHelmet) {
                    HeavyIronHelmet heavyIronHelmet = (HeavyIronHelmet)model;
                    boolean isOpened = Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED));
                    heavyIronHelmet.getHead().getChild((String)"cap_hinge").y = isOpened ? -9.0f : -4.0f;
                    heavyIronHelmet.getHead().getChild((String)"cap_hinge").xRot = isOpened ? -0.5f : 0.0f;
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public int getDefaultDyeColor(ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)defaultColor)) : -1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(HeavyIronHelmet.LAYER_LOCATION);
                return new HeavyIronHelmet(part);
            }
        }, new Item[]{item});
    }

    private static void registerHeavyGoldenHelmetModel(RegisterClientExtensionsEvent event, Item item, final int defaultColor) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public void setupModelAnimations(LivingEntity entity, ItemStack stack, EquipmentSlot slot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                if (model instanceof HeavyGoldenHelmet) {
                    HeavyGoldenHelmet heavyGoldenHelmet = (HeavyGoldenHelmet)model;
                    boolean isOpened = Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED));
                    heavyGoldenHelmet.getHead().getChild((String)"cap_hinge").y = isOpened ? -9.0f : -4.0f;
                    heavyGoldenHelmet.getHead().getChild((String)"cap_hinge").xRot = isOpened ? -0.5f : 0.0f;
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public int getDefaultDyeColor(ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)defaultColor)) : -1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(HeavyGoldenHelmet.LAYER_LOCATION);
                return new HeavyGoldenHelmet(part);
            }
        }, new Item[]{item});
    }

    private static void registerHeavyDiamondHelmetModel(RegisterClientExtensionsEvent event, Item item, final int defaultColor) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public void setupModelAnimations(LivingEntity entity, ItemStack stack, EquipmentSlot slot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                if (model instanceof HeavyDiamondHelmet) {
                    HeavyDiamondHelmet heavyDiamondHelmet = (HeavyDiamondHelmet)model;
                    boolean isOpened = Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED));
                    heavyDiamondHelmet.getHead().getChild((String)"offset").y = isOpened ? -6.0f : 0.0f;
                    heavyDiamondHelmet.getHead().getChild((String)"offset").xRot = isOpened ? -0.5f : 0.0f;
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public int getDefaultDyeColor(ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)defaultColor)) : -1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(HeavyDiamondHelmet.LAYER_LOCATION);
                return new HeavyDiamondHelmet(part);
            }
        }, new Item[]{item});
    }

    private static void registerHeavyNetheriteHelmetModel(RegisterClientExtensionsEvent event, Item item, final int defaultColor) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public int getDefaultDyeColor(ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)defaultColor)) : -1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(HeavyNetheriteHelmet.LAYER_LOCATION);
                return new HeavyNetheriteHelmet(part);
            }
        }, new Item[]{item});
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LightChestplate.LAYER_LOCATION, LightChestplate::createBodyLayer);
        event.registerLayerDefinition(HeavyIronHelmet.LAYER_LOCATION, HeavyIronHelmet::createBodyLayer);
        event.registerLayerDefinition(HeavyGoldenHelmet.LAYER_LOCATION, HeavyGoldenHelmet::createBodyLayer);
        event.registerLayerDefinition(HeavyDiamondHelmet.LAYER_LOCATION, HeavyDiamondHelmet::createBodyLayer);
        event.registerLayerDefinition(HeavyNetheriteHelmet.LAYER_LOCATION, HeavyNetheriteHelmet::createBodyLayer);
        event.registerLayerDefinition(HeavyChestplate.LAYER_LOCATION, HeavyChestplate::createBodyLayer);
        event.registerLayerDefinition(HeavyLeggings.LAYER_LOCATION, HeavyLeggings::createBodyLayer);
        event.registerLayerDefinition(HeavyBoots.LAYER_LOCATION, HeavyBoots::createBodyLayer);
    }
}

