/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.items.armor;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.armor.DyedArmor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;

public abstract class HeavyArmorItem
extends ArmorItem
implements DyedArmor {
    private static final ResourceLocation BOOTS_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.boots");
    private static final ResourceLocation LEGGINGS_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.leggings");
    private static final ResourceLocation CHESTPLATE_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.chestplate");
    private static final ResourceLocation HELMET_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.helmet");
    protected static String TEXTURE_PATH = "textures/entity/equipment/humanoid/";
    protected static final ResourceLocation HEAVY_ARMOR_DYE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)(TEXTURE_PATH + "heavy_armor_dye_overlay.png"));
    private final Supplier<ItemAttributeModifiers> heavyModifiers = Suppliers.memoize(() -> {
        int defense = ((ArmorMaterial)material.value()).getDefense(type);
        float toughness = ((ArmorMaterial)material.value()).toughness();
        float knockbackResistance = ((ArmorMaterial)material.value()).knockbackResistance();
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation armorModifierID = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ARMOR, new AttributeModifier(armorModifierID, (double)defense, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(armorModifierID, (double)toughness, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        if (knockbackResistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(armorModifierID, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        ResourceLocation movementSpeedID = switch (type.getSlot()) {
            case EquipmentSlot.FEET -> BOOTS_SPEED_ID;
            case EquipmentSlot.LEGS -> LEGGINGS_SPEED_ID;
            case EquipmentSlot.CHEST -> CHESTPLATE_SPEED_ID;
            case EquipmentSlot.HEAD -> HELMET_SPEED_ID;
            default -> throw new IllegalStateException("Unexpected slot: " + String.valueOf(type.getSlot()));
        };
        builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(movementSpeedID, -0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slotGroup);
        return builder.build();
    });

    public static float getFullnessDisplay(ItemStack stack) {
        return Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED)) ? 1.0f : 0.0f;
    }

    public HeavyArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public DyedItemColor getDefaultDyeColor() {
        return null;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (this.isSameColorAsDefault(stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.luckysarmory.dyeable").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.heavyModifiers.get();
    }

    protected boolean isSameColorAsDefault(ItemStack stack) {
        return stack.has(DataComponents.DYED_COLOR) && stack.get(DataComponents.DYED_COLOR) != this.getDefaultDyeColor();
    }
}

