/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.items.armor;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.luckystudios.components.ModDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class LightArmorItem
extends ArmorItem {
    private static final ResourceLocation BOOTS_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.boots");
    private static final ResourceLocation LEGGINGS_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.leggings");
    private static final ResourceLocation CHESTPLATE_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.chestplate");
    private static final ResourceLocation HELMET_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"armor.slowness.helmet");
    protected static String TEXTURE_PATH = "textures/entity/equipment/humanoid/";
    protected static final ResourceLocation HEAVY_ARMOR_DYE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)(TEXTURE_PATH + "heavy_armor_dye_overlay.png"));
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> {
        int defense = ((ArmorMaterial)material.value()).getDefense(type);
        float toughness = ((ArmorMaterial)material.value()).toughness();
        float knockbackResistance = ((ArmorMaterial)material.value()).knockbackResistance();
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation armorModifierID = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ARMOR, new AttributeModifier(armorModifierID, (double)defense, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(armorModifierID, (double)toughness, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        if (knockbackResistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(armorModifierID, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        double speedBoost = 0.05;
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(switch (type.getSlot()) {
            case EquipmentSlot.FEET -> BOOTS_SPEED_ID;
            case EquipmentSlot.LEGS -> LEGGINGS_SPEED_ID;
            case EquipmentSlot.CHEST -> CHESTPLATE_SPEED_ID;
            case EquipmentSlot.HEAD -> HELMET_SPEED_ID;
            default -> throw new IllegalStateException("Unexpected slot: " + String.valueOf(type.getSlot()));
        }, speedBoost, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slotGroup);
        return builder.build();
    });

    public static float getFullnessDisplay(ItemStack stack) {
        return Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED)) ? 1.0f : 0.0f;
    }

    public LightArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.type.getSlot() == EquipmentSlot.HEAD) {
            if (Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED))) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.luckysarmory.opened"));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.luckysarmory.closed"));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

