/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.items.armor.custom;

import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.armor.HeavyArmorItem;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

public class HeavyNetheriteArmorItem
extends HeavyArmorItem {
    public HeavyNetheriteArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public DyedItemColor getDefaultDyeColor() {
        return new DyedItemColor(DyeColor.BLACK.getTextureDiffuseColor(), false);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        boolean isOpened = Boolean.TRUE.equals(stack.get(ModDataComponents.OPENED));
        if (layer.dyeable()) {
            if (slot == EquipmentSlot.HEAD) {
                return isOpened ? ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_helmet_opened_dye_overlay.png") : ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_helmet_dye_overlay.png");
            }
            if (slot == EquipmentSlot.CHEST) {
                return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_chestplate_dye_overlay.png");
            }
            if (slot == EquipmentSlot.LEGS) {
                return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_leggings_dye_overlay.png");
            }
            if (slot == EquipmentSlot.FEET) {
                return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_boots_dye_overlay.png");
            }
        }
        if (slot == EquipmentSlot.HEAD) {
            return isOpened ? ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_helmet_opened.png") : ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_helmet.png");
        }
        if (slot == EquipmentSlot.CHEST) {
            return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_chestplate.png");
        }
        if (slot == EquipmentSlot.LEGS) {
            return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_leggings.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"textures/entity/equipment/humanoid/heavy_netherite_boots.png");
    }
}

