/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.keybinds;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.luckystudios.components.ModDataComponents;
import net.luckystudios.items.armor.HeavyArmorItem;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HelmetTogglePacket(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HelmetTogglePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"luckysarmory", (String)"key_helmet_toggle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HelmetTogglePacket> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new HelmetTogglePacket(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(HelmetTogglePacket message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> HelmetTogglePacket.pressAction(context.player(), context.player().getItemBySlot(EquipmentSlot.HEAD), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player player, ItemStack helmet, int type, int pressedms) {
        Level world = player.level();
        if (!world.hasChunkAt(player.blockPosition())) {
            return;
        }
        if (type != 0) {
            return;
        }
        boolean opened = Boolean.TRUE.equals(helmet.get(ModDataComponents.OPENED));
        ItemStack newHelmet = helmet.copy();
        newHelmet.set(ModDataComponents.OPENED, (Object)(!opened ? 1 : 0));
        Item item = newHelmet.getItem();
        if (item instanceof HeavyArmorItem) {
            HeavyArmorItem heavyArmorItem = (HeavyArmorItem)item;
            Holder armorMaterial = heavyArmorItem.getMaterial();
            ArmorMaterial material = (ArmorMaterial)armorMaterial.value();
            int defaultDefense = material.getDefense(ArmorItem.Type.HELMET);
            int modifiedDefense = opened ? defaultDefense : defaultDefense / 2;
            List oldEntries = newHelmet.getAttributeModifiers().modifiers();
            ImmutableList.Builder builder = ImmutableList.builder();
            ItemAttributeModifiers.Entry newArmorEntry = new ItemAttributeModifiers.Entry(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"armor.helmet"), (double)modifiedDefense, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
            builder.add((Object)newArmorEntry);
            for (ItemAttributeModifiers.Entry entry : oldEntries) {
                if (entry.matches(Attributes.ARMOR, newArmorEntry.modifier().id())) continue;
                builder.add((Object)entry);
            }
            newHelmet.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers((List)builder.build(), true));
            player.setItemSlot(EquipmentSlot.HEAD, newHelmet);
            player.swing(InteractionHand.OFF_HAND);
        }
    }
}

