/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudios.keybinds;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.function.Supplier;
import net.luckystudios.items.ModItems;
import net.luckystudios.keybinds.HelmetTogglePacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TestModKeyMappings {
    public static final Supplier<KeyMapping> TOGGLE_HELMET = Suppliers.memoize(() -> new KeyMapping("key.luckysarmory.helmet_toggle", InputConstants.Type.KEYSYM, 72, "key.categories.gameplay"));
    public static final Supplier<List<Item>> getHeavyHelmets = Suppliers.memoize(() -> List.of((Item)ModItems.HEAVY_IRON_HELMET.get(), (Item)ModItems.HEAVY_GOLDEN_HELMET.get(), (Item)ModItems.HEAVY_DIAMOND_HELMET.get(), (Item)ModItems.HEAVY_NETHERITE_HELMET.get()));

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(TOGGLE_HELMET.get());
    }

    public static String getKeyName(Supplier<KeyMapping> toggleHelmet) {
        KeyMapping keyMapping = toggleHelmet.get();
        return keyMapping.getKey().getDisplayName().getString();
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                while (TOGGLE_HELMET.get().consumeClick()) {
                    ClientLevel level = Minecraft.getInstance().level;
                    LocalPlayer player = Minecraft.getInstance().player;
                    ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
                    if (!getHeavyHelmets.get().contains(helmet.getItem())) continue;
                    PacketDistributor.sendToServer((CustomPacketPayload)new HelmetTogglePacket(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    HelmetTogglePacket.pressAction((Player)player, helmet, 0, 0);
                }
            }
        }
    }
}

