/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin;

import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;

public class NBTDebugCommand
implements CommandExecutor {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;

    public NBTDebugCommand(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            this.languageManager.sendMessage(player, "nbt_debug.no_item", new Object[0]);
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String cmdString = CustomModelDataUtil.getCustomModelDataString(item);
            int cmdInt = CustomModelDataUtil.getCustomModelDataInt(item);
            if (cmdString != null) {
                this.languageManager.sendMessage(player, "nbt_debug.custom_model_data_string", cmdString);
            } else {
                this.languageManager.sendMessage(player, "nbt_debug.no_string_data", new Object[0]);
            }
            if (cmdInt > 0) {
                this.languageManager.sendMessage(player, "nbt_debug.custom_model_data_int", cmdInt);
            } else {
                this.languageManager.sendMessage(player, "nbt_debug.no_int_data", new Object[0]);
            }
            String apiType = CustomModelDataUtil.isNewApiSupported() ? this.languageManager.getMessage(player, "nbt_debug.api_new", new Object[0]) : this.languageManager.getMessage(player, "nbt_debug.api_old", new Object[0]);
            this.languageManager.sendMessage(player, "nbt_debug.api_version", apiType);
            if (meta.hasLore()) {
                this.languageManager.sendMessage(player, "nbt_debug.lore_header", new Object[0]);
                for (String line : meta.getLore()) {
                    this.languageManager.sendMessage(player, "nbt_debug.lore_item", line);
                }
            } else {
                this.languageManager.sendMessage(player, "nbt_debug.no_lore", new Object[0]);
            }
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            if (!pdc.isEmpty()) {
                this.languageManager.sendMessage(player, "nbt_debug.pdc_header", new Object[0]);
                for (NamespacedKey key : pdc.getKeys()) {
                    try {
                        String value = "\u672a\u77e5\u7c7b\u578b";
                        if (pdc.has(key, PersistentDataType.STRING)) {
                            value = (String)pdc.get(key, PersistentDataType.STRING);
                        } else if (pdc.has(key, PersistentDataType.INTEGER)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.INTEGER));
                        } else if (pdc.has(key, PersistentDataType.DOUBLE)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.DOUBLE));
                        } else if (pdc.has(key, PersistentDataType.BOOLEAN)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.BOOLEAN));
                        } else if (pdc.has(key, PersistentDataType.LONG)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.LONG));
                        } else if (pdc.has(key, PersistentDataType.FLOAT)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.FLOAT));
                        } else if (pdc.has(key, PersistentDataType.BYTE)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.BYTE));
                        } else if (pdc.has(key, PersistentDataType.SHORT)) {
                            value = String.valueOf(pdc.get(key, PersistentDataType.SHORT));
                        }
                        this.languageManager.sendMessage(player, "nbt_debug.pdc_item", key.toString(), value);
                    }
                    catch (Exception e) {
                        this.languageManager.sendMessage(player, "nbt_debug.pdc_item", key.toString(), "\u8bfb\u53d6\u5931\u8d25: " + e.getMessage());
                    }
                }
            } else {
                this.languageManager.sendMessage(player, "nbt_debug.no_pdc", new Object[0]);
            }
        } else {
            this.languageManager.sendMessage(player, "nbt_debug.no_metadata", new Object[0]);
        }
        return true;
    }
}

