/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.GUIManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;

public class GUICommand
implements CommandExecutor,
TabCompleter {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final GUIManager guiManager;

    public GUICommand(Avaritia_Plugin plugin, LanguageManager languageManager, GUIManager guiManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.guiManager = guiManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int size;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("avaritia.gui.use")) {
            this.languageManager.sendMessage(player, "general.no_permission", new Object[0]);
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("create")) {
            int size2;
            if (args.length < 3) {
                player.sendMessage("\u00a7c\u7528\u6cd5: /gui create <\u6587\u4ef6\u540d> <\u5927\u5c0f>");
                player.sendMessage("\u00a77\u793a\u4f8b: /gui create extreme_table 54");
                return true;
            }
            String fileName = args[1];
            String sizeArg = args[2];
            try {
                size2 = Integer.parseInt(sizeArg);
            }
            catch (NumberFormatException e) {
                this.languageManager.sendMessage(player, "gui.invalid_size", sizeArg);
                return true;
            }
            if (!this.isValidSize(size2)) {
                this.languageManager.sendMessage(player, "gui.invalid_size_range", size2);
                return true;
            }
            this.guiManager.openCreateGUI(player, fileName, size2);
            return true;
        }
        if (args.length < 2) {
            this.sendUsage(player);
            return true;
        }
        String sizeArg = args[1];
        try {
            size = Integer.parseInt(sizeArg);
        }
        catch (NumberFormatException e) {
            this.languageManager.sendMessage(player, "gui.invalid_size", sizeArg);
            return true;
        }
        if (!this.isValidSize(size)) {
            this.languageManager.sendMessage(player, "gui.invalid_size_range", size);
            return true;
        }
        switch (action) {
            case "edit": {
                if (!player.hasPermission("avaritia.gui.edit")) {
                    this.languageManager.sendMessage(player, "general.no_permission", new Object[0]);
                    return true;
                }
                this.guiManager.openEditGUI(player, size);
                break;
            }
            case "look": 
            case "view": {
                this.guiManager.openViewGUI(player, size);
                break;
            }
            case "new": 
            case "create": {
                if (!player.hasPermission("avaritia.gui.create")) {
                    this.languageManager.sendMessage(player, "general.no_permission", new Object[0]);
                    return true;
                }
                this.guiManager.openNewGUI(player, size);
                break;
            }
            default: {
                this.sendUsage(player);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block8: {
            int[] commonSizes;
            block9: {
                int[] commonSizes2;
                block7: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block7;
                    String input = args[0].toLowerCase();
                    for (String action : Arrays.asList("edit", "look", "view", "new", "create")) {
                        if (!action.startsWith(input)) continue;
                        completions.add(action);
                    }
                    break block8;
                }
                if (args.length != 2) break block9;
                String action = args[0].toLowerCase();
                if (action.equals("create")) {
                    completions.add("<\u6587\u4ef6\u540d>");
                    return completions;
                }
                String input = args[1];
                for (int size : commonSizes2 = new int[]{1, 5, 9, 18, 27, 36, 45, 54}) {
                    String sizeStr = String.valueOf(size);
                    if (!sizeStr.startsWith(input)) continue;
                    completions.add(sizeStr);
                }
                try {
                    int inputNum = Integer.parseInt(input);
                    for (int i = Math.max(1, inputNum); i <= Math.min(54, inputNum + 10); ++i) {
                        String sizeStr = String.valueOf(i);
                        if (!sizeStr.startsWith(input) || completions.contains(sizeStr)) continue;
                        completions.add(sizeStr);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                break block8;
            }
            if (args.length != 3 || !args[0].equalsIgnoreCase("create")) break block8;
            String input = args[2];
            for (int size : commonSizes = new int[]{1, 5, 9, 18, 27, 36, 45, 54}) {
                String sizeStr = String.valueOf(size);
                if (!sizeStr.startsWith(input)) continue;
                completions.add(sizeStr);
            }
        }
        return completions;
    }

    private boolean isValidSize(int size) {
        return size >= 1 && size <= 54;
    }

    private void sendUsage(Player player) {
        this.languageManager.sendMessage(player, "gui.usage_header", new Object[0]);
        this.languageManager.sendMessage(player, "gui.usage_edit", new Object[0]);
        this.languageManager.sendMessage(player, "gui.usage_look", new Object[0]);
        this.languageManager.sendMessage(player, "gui.usage_new", new Object[0]);
        this.languageManager.sendMessage(player, "gui.size_note", new Object[0]);
        this.languageManager.sendMessage(player, "gui.size_examples", new Object[0]);
    }
}

