/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class GiveCommand {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;

    public GiveCommand(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
    }

    public boolean execute(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("avaritia.give") && !sender.isOp()) {
            if (sender instanceof Player) {
                this.languageManager.sendMessage((Player)sender, "command.no_permission", new Object[0]);
            } else {
                sender.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4!");
            }
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7c\u7528\u6cd5: /avaritia give <\u73a9\u5bb6> <\u7269\u54c1ID> [\u6570\u91cf]");
            sender.sendMessage("\u00a77\u793a\u4f8b: /avaritia give @p neutron_dust 64");
            return true;
        }
        String targetName = args[0];
        String itemId = args[1];
        int amount = 1;
        if (args.length >= 3) {
            try {
                amount = Integer.parseInt(args[2]);
                if (amount <= 0 || amount > 64) {
                    sender.sendMessage("\u00a7c\u6570\u91cf\u5fc5\u987b\u57281-64\u4e4b\u95f4\uff01");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c\u65e0\u6548\u7684\u6570\u91cf: " + args[2]);
                return true;
            }
        }
        if ((target = Bukkit.getPlayer((String)targetName)) == null) {
            sender.sendMessage("\u00a7c\u73a9\u5bb6\u4e0d\u5728\u7ebf: " + targetName);
            return true;
        }
        ItemStack item = this.createItem(itemId, target, amount);
        if (item == null) {
            sender.sendMessage("\u00a7c\u672a\u627e\u5230\u7269\u54c1: " + itemId);
            sender.sendMessage("\u00a77\u4f7f\u7528 /avaritia give list \u67e5\u770b\u53ef\u7528\u7269\u54c1");
            return true;
        }
        target.getInventory().addItem(new ItemStack[]{item});
        String itemName = item.getItemMeta() != null ? item.getItemMeta().getDisplayName() : itemId;
        sender.sendMessage("\u00a7a\u5df2\u7ed9\u4e88 " + target.getName() + " \u00a7r" + itemName + " \u00a7ax" + amount);
        target.sendMessage("\u00a7a\u4f60\u83b7\u5f97\u4e86 \u00a7r" + itemName + " \u00a7ax" + amount);
        return true;
    }

    private ItemStack createItem(String itemId, Player player, int amount) {
        YamlConfiguration recipeConfig;
        ConfigurationSection recipeSection;
        YamlConfiguration itemsConfig;
        ConfigurationSection itemSection;
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!itemsFile.exists()) {
            this.plugin.saveResource("items.yml", false);
        }
        if ((itemSection = (itemsConfig = YamlConfiguration.loadConfiguration((File)itemsFile)).getConfigurationSection("items." + itemId)) != null) {
            return this.createItemFromSection(itemSection, player, itemId, amount);
        }
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (recipeFile.exists() && (recipeSection = (recipeConfig = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes." + itemId + ".result")) != null) {
            return this.createItemFromRecipeResult(recipeSection, player, itemId, amount);
        }
        return null;
    }

    private ItemStack createItemFromSection(ConfigurationSection section, Player player, String itemId, int amount) {
        ItemMeta meta;
        String cmd;
        String materialName = section.getString("material", "STONE");
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material, amount);
        if (section.contains("custom_model_data") && (cmd = section.isInt("custom_model_data") ? String.valueOf(section.getInt("custom_model_data")) : section.getString("custom_model_data")) != null && !cmd.isEmpty()) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[Give\u547d\u4ee4] \u4e3a\u7269\u54c1 " + itemId + " \u8bbe\u7f6eCMD: " + cmd);
            }
        }
        if ((meta = item.getItemMeta()) != null) {
            int maxDurability;
            List loreKeys;
            String displayNameKey = section.getString("display_name");
            if (displayNameKey != null) {
                String displayName = this.languageManager.getMessage(player, displayNameKey, new Object[0]);
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
            }
            if (!(loreKeys = section.getStringList("lore")).isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String loreKey : loreKeys) {
                    String loreLine = this.languageManager.getMessage(player, loreKey, new Object[0]);
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine));
                }
                meta.setLore(lore);
            }
            if (section.getBoolean("unbreakable", false)) {
                meta.setUnbreakable(true);
            }
            if (section.contains("max_durability") && (maxDurability = section.getInt("max_durability")) > 0 && meta.getLore() != null) {
                ArrayList<Object> currentLore = new ArrayList<Object>(meta.getLore());
                currentLore.add("");
                currentLore.add(String.valueOf(ChatColor.GRAY) + "\u8010\u4e45: " + String.valueOf(ChatColor.GREEN) + maxDurability + "/" + maxDurability);
                meta.setLore(currentLore);
            }
            item.setItemMeta(meta);
        }
        item = PDCUtil.addPluginData(item, itemId);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            boolean hasPluginData = PDCUtil.isPluginItem(item);
            String storedItemId = PDCUtil.getItemId(item);
            this.plugin.getLogger().info("[Give\u547d\u4ee4] \u7269\u54c1PDC\u9a8c\u8bc1 - \u662f\u63d2\u4ef6\u7269\u54c1: " + hasPluginData + ", \u7269\u54c1ID: " + storedItemId);
        }
        return item;
    }

    private ItemStack createItemFromRecipeResult(ConfigurationSection section, Player player, String itemId, int amount) {
        ItemMeta meta;
        String cmd;
        String materialName = section.getString("material", "STONE");
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material, amount);
        if (section.contains("custom_model_data") && (cmd = section.isInt("custom_model_data") ? String.valueOf(section.getInt("custom_model_data")) : section.getString("custom_model_data")) != null && !cmd.isEmpty()) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[Give\u547d\u4ee4-Recipe] \u4e3a\u7269\u54c1 " + itemId + " \u8bbe\u7f6eCMD: " + cmd);
            }
        }
        if ((meta = item.getItemMeta()) != null) {
            List loreKeys;
            String displayNameKey = section.getString("display_name");
            if (displayNameKey != null) {
                String displayName = this.languageManager.getMessage(player, displayNameKey, new Object[0]);
                meta.setDisplayName(displayName);
            }
            if (!(loreKeys = section.getStringList("lore")).isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String loreKey : loreKeys) {
                    lore.add(this.languageManager.getMessage(player, loreKey, new Object[0]));
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        item = PDCUtil.addPluginData(item, itemId);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            boolean hasPluginData = PDCUtil.isPluginItem(item);
            String storedItemId = PDCUtil.getItemId(item);
            this.plugin.getLogger().info("[Give\u547d\u4ee4-Recipe] \u7269\u54c1PDC\u9a8c\u8bc1 - \u662f\u63d2\u4ef6\u7269\u54c1: " + hasPluginData + ", \u7269\u54c1ID: " + storedItemId);
        }
        return item;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length == 2) {
            List<String> itemIds = this.getAllItemIds();
            for (String itemId : itemIds) {
                if (!itemId.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(itemId);
            }
        } else if (args.length == 3) {
            completions.add("1");
            completions.add("16");
            completions.add("32");
            completions.add("64");
        }
        return completions;
    }

    private List<String> getAllItemIds() {
        YamlConfiguration recipeConfig;
        ConfigurationSection recipesSection;
        File recipeFile;
        YamlConfiguration itemsConfig;
        ConfigurationSection itemsSection;
        ArrayList<String> itemIds = new ArrayList<String>();
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (itemsFile.exists() && (itemsSection = (itemsConfig = YamlConfiguration.loadConfiguration((File)itemsFile)).getConfigurationSection("items")) != null) {
            itemIds.addAll(itemsSection.getKeys(false));
        }
        if ((recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml")).exists() && (recipesSection = (recipeConfig = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes")) != null) {
            for (String key : recipesSection.getKeys(false)) {
                if (key.contains("_to_") || key.contains("_from_") || itemIds.contains(key)) continue;
                itemIds.add(key);
            }
        }
        return itemIds;
    }
}

