/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.little100.avaritia_Plugin.Avaritia_Plugin;

public class BlockDatabase {
    private final Avaritia_Plugin plugin;
    private Connection connection;
    private final File databaseFile;

    public BlockDatabase(Avaritia_Plugin plugin) {
        this.plugin = plugin;
        this.databaseFile = new File(plugin.getDataFolder(), "blocks.db");
    }

    public void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getAbsolutePath());
            this.createTables();
            this.plugin.getLogger().info("\u65b9\u5757\u6570\u636e\u5e93\u521d\u59cb\u5316\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u65b9\u5757\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createTables() throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS custom_blocks (id INTEGER PRIMARY KEY AUTOINCREMENT,world TEXT NOT NULL,x INTEGER NOT NULL,y INTEGER NOT NULL,z INTEGER NOT NULL,block_type TEXT NOT NULL,armor_stand_uuid TEXT NOT NULL,item_id TEXT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE(world, x, y, z))";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
    }

    public void saveBlock(Location location, String blockType, UUID armorStandUUID, String itemId) {
        String sql = "INSERT OR REPLACE INTO custom_blocks (world, x, y, z, block_type, armor_stand_uuid, item_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX());
            pstmt.setInt(3, location.getBlockY());
            pstmt.setInt(4, location.getBlockZ());
            pstmt.setString(5, blockType);
            pstmt.setString(6, armorStandUUID.toString());
            pstmt.setString(7, itemId);
            pstmt.executeUpdate();
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u4fdd\u5b58\u65b9\u5757\u5230\u6570\u636e\u5e93: " + blockType + " at " + String.valueOf(location));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u4fdd\u5b58\u65b9\u5757\u5931\u8d25: " + e.getMessage());
        }
    }

    public void removeBlock(Location location) {
        String sql = "DELETE FROM custom_blocks WHERE world = ? AND x = ? AND y = ? AND z = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX());
            pstmt.setInt(3, location.getBlockY());
            pstmt.setInt(4, location.getBlockZ());
            pstmt.executeUpdate();
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u4ece\u6570\u636e\u5e93\u5220\u9664\u65b9\u5757: " + String.valueOf(location));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u5220\u9664\u65b9\u5757\u5931\u8d25: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasBlock(Location location) {
        String sql = "SELECT COUNT(*) FROM custom_blocks WHERE world = ? AND x = ? AND y = ? AND z = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX());
            pstmt.setInt(3, location.getBlockY());
            pstmt.setInt(4, location.getBlockZ());
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getInt(1) > 0;
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u68c0\u67e5\u65b9\u5757\u5931\u8d25: " + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getArmorStandUUID(Location location) {
        String sql = "SELECT armor_stand_uuid FROM custom_blocks WHERE world = ? AND x = ? AND y = ? AND z = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX());
            pstmt.setInt(3, location.getBlockY());
            pstmt.setInt(4, location.getBlockZ());
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                UUID uUID = UUID.fromString(rs.getString("armor_stand_uuid"));
                return uUID;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u83b7\u53d6\u76d4\u7532\u67b6UUID\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBlockType(Location location) {
        String sql = "SELECT block_type FROM custom_blocks WHERE world = ? AND x = ? AND y = ? AND z = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX());
            pstmt.setInt(3, location.getBlockY());
            pstmt.setInt(4, location.getBlockZ());
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("block_type");
                return string;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u83b7\u53d6\u65b9\u5757\u7c7b\u578b\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    public Map<Location, UUID> loadAllBlocks() {
        HashMap<Location, UUID> blocks = new HashMap<Location, UUID>();
        String sql = "SELECT * FROM custom_blocks";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                String worldName = rs.getString("world");
                int x = rs.getInt("x");
                int y = rs.getInt("y");
                int z = rs.getInt("z");
                UUID armorStandUUID = UUID.fromString(rs.getString("armor_stand_uuid"));
                Location loc = new Location(Bukkit.getWorld((String)worldName), (double)x, (double)y, (double)z);
                blocks.put(loc, armorStandUUID);
            }
            this.plugin.getLogger().info("\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u4e86 " + blocks.size() + " \u4e2a\u65b9\u5757");
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("\u52a0\u8f7d\u65b9\u5757\u5931\u8d25: " + e.getMessage());
        }
        return blocks;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("\u65b9\u5757\u6570\u636e\u5e93\u5df2\u5173\u95ed");
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("\u5173\u95ed\u6570\u636e\u5e93\u5931\u8d25: " + e.getMessage());
            }
        }
    }
}

