/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.CustomCraftingManager;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class CraftingListener
implements Listener {
    private final Avaritia_Plugin plugin;
    private final CustomCraftingManager craftingManager;

    public CraftingListener(Avaritia_Plugin plugin, CustomCraftingManager craftingManager) {
        this.plugin = plugin;
        this.craftingManager = craftingManager;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack[] matrix = event.getInventory().getMatrix();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== \u5408\u6210\u4e8b\u4ef6\u68c0\u67e5\u5f00\u59cb ===");
            for (int i = 0; i < matrix.length; ++i) {
                void var4_4;
                if (matrix[i] == null || matrix[i].getType().isAir()) continue;
                String string = matrix[i].getType().name();
                if (PDCUtil.isPluginItem(matrix[i])) {
                    String string2 = string + " (\u63d2\u4ef6\u7269\u54c1: " + PDCUtil.getItemId(matrix[i]) + ")";
                }
                this.plugin.getLogger().info("\u4f4d\u7f6e " + i + ": " + (String)var4_4);
            }
        }
        boolean hasPluginMaterial = false;
        for (ItemStack item : matrix) {
            if (item == null || !PDCUtil.isPluginItem(item)) continue;
            hasPluginMaterial = true;
            break;
        }
        if (hasPluginMaterial) {
            void var4_10;
            ItemStack customResult;
            String string = "zh_cn";
            if (event.getView() != null && event.getView().getPlayer() instanceof Player) {
                Player player = (Player)event.getView().getPlayer();
                String string3 = this.plugin.getLanguageManager().getPlayerLanguage(player);
            }
            if ((customResult = this.craftingManager.findMatchingRecipe(matrix, (String)var4_10)) != null) {
                event.getInventory().setResult(customResult);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u2713 \u68c0\u6d4b\u5230\u6709\u6548\u81ea\u5b9a\u4e49\u5408\u6210: " + PDCUtil.getItemId(customResult) + " (\u8bed\u8a00: " + (String)var4_10 + ")");
                }
            } else {
                event.getInventory().setResult(null);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u2717 \u963b\u6b62\u4e86\u65e0\u6548\u7684\u63d2\u4ef6\u7269\u54c1\u5408\u6210\uff08\u6750\u6599\u9a8c\u8bc1\u5931\u8d25\uff09");
                }
            }
        } else {
            ItemStack itemStack = event.getInventory().getResult();
            if (itemStack != null && PDCUtil.isPluginItem(itemStack)) {
                ItemStack translatedResult;
                String language = "zh_cn";
                if (event.getView() != null && event.getView().getPlayer() instanceof Player) {
                    Player player = (Player)event.getView().getPlayer();
                    language = this.plugin.getLanguageManager().getPlayerLanguage(player);
                }
                if ((translatedResult = this.craftingManager.createLocalizedItem(itemStack, language)) != null) {
                    event.getInventory().setResult(translatedResult);
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        this.plugin.getLogger().info("\u2713 \u7eaf\u539f\u7248\u6750\u6599\u5408\u6210\u63d2\u4ef6\u7269\u54c1\uff08\u5df2\u672c\u5730\u5316\uff09: " + PDCUtil.getItemId(translatedResult) + " (\u8bed\u8a00: " + language + ")");
                    }
                } else if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u2713 \u7eaf\u539f\u7248\u6750\u6599\u5408\u6210\u63d2\u4ef6\u7269\u54c1: " + PDCUtil.getItemId(itemStack));
                }
            } else if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u25cb \u7eaf\u539f\u7248\u7269\u54c1\u5408\u6210");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCraftItem(CraftItemEvent event) {
        ItemStack[] matrix = event.getInventory().getMatrix();
        ItemStack actualResult = event.getInventory().getResult();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            Object resultDesc;
            Object object = resultDesc = actualResult != null ? actualResult.getType().name() : "null";
            if (actualResult != null && PDCUtil.isPluginItem(actualResult)) {
                resultDesc = (String)resultDesc + " (\u63d2\u4ef6\u7269\u54c1: " + PDCUtil.getItemId(actualResult) + ")";
            }
            this.plugin.getLogger().info("=== \u5408\u6210\u7269\u54c1\u4e8b\u4ef6: " + (String)resultDesc + " ===");
        }
        boolean hasPluginMaterial = false;
        for (ItemStack item : matrix) {
            if (item == null || !PDCUtil.isPluginItem(item)) continue;
            hasPluginMaterial = true;
            break;
        }
        if (hasPluginMaterial) {
            if (actualResult != null && PDCUtil.isPluginItem(actualResult)) {
                this.craftingManager.consumeIngredients(matrix, actualResult);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u2713 \u5b8c\u6210\u81ea\u5b9a\u4e49\u5408\u6210: " + PDCUtil.getItemId(actualResult));
                }
            } else {
                event.setCancelled(true);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u2717 \u53d6\u6d88\u4e86\u65e0\u6548\u7684\u63d2\u4ef6\u7269\u54c1\u5408\u6210");
                }
            }
        } else if (actualResult != null && PDCUtil.isPluginItem(actualResult)) {
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u2713 \u5b8c\u6210\u539f\u7248\u6750\u6599\u7684\u63d2\u4ef6\u7269\u54c1\u5408\u6210: " + PDCUtil.getItemId(actualResult));
            }
        } else if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u25cb \u7eaf\u539f\u7248\u7269\u54c1\u5408\u6210");
        }
    }
}

