/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class InfinityArmorListener
implements Listener {
    private final Avaritia_Plugin plugin;
    private final Set<UUID> flyingPlayers = new HashSet<UUID>();
    private final Map<UUID, Boolean> fullSetNotified = new HashMap<UUID, Boolean>();

    public InfinityArmorListener(Avaritia_Plugin plugin) {
        this.plugin = plugin;
        this.startArmorCheckTask();
    }

    private void startArmorCheckTask() {
        FoliaUtil.runGlobalTimer(this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.checkInfinityArmorEffects(player);
            }
        }, 20L, 20L);
    }

    private void checkInfinityArmorEffects(Player player) {
        ItemStack helmet = player.getInventory().getHelmet();
        ItemStack chestplate = player.getInventory().getChestplate();
        ItemStack leggings = player.getInventory().getLeggings();
        ItemStack boots = player.getInventory().getBoots();
        boolean hasHelmet = "infinity_helmet".equals(PDCUtil.getItemId(helmet));
        boolean hasChestplate = "infinity_chestplate".equals(PDCUtil.getItemId(chestplate));
        boolean hasLeggings = "infinity_leggings".equals(PDCUtil.getItemId(leggings));
        boolean hasBoots = "infinity_boots".equals(PDCUtil.getItemId(boots));
        boolean hasFullSet = hasHelmet && hasChestplate && hasLeggings && hasBoots;
        UUID uuid = player.getUniqueId();
        FoliaUtil.runEntityTask(this.plugin, (Entity)player, () -> {
            if (hasHelmet) {
                player.setRemainingAir(player.getMaximumAir());
                player.setFoodLevel(20);
                player.setSaturation(20.0f);
                player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 220, 0, false, false));
            }
            if (hasChestplate) {
                if (!this.flyingPlayers.contains(uuid)) {
                    this.flyingPlayers.add(uuid);
                    player.setAllowFlight(true);
                }
                this.removeDebuffs(player);
            } else if (this.flyingPlayers.contains(uuid)) {
                this.flyingPlayers.remove(uuid);
                if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                }
            }
            if (hasLeggings && player.getFireTicks() > 0) {
                player.setFireTicks(0);
            }
            if (hasBoots) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 60, 9, false, false));
            }
            if (hasFullSet) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 60, 4, true, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 60, 0, true, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 60, 0, true, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, 60, 9, true, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 60, 1, true, false));
                if (!this.fullSetNotified.getOrDefault(uuid, false).booleanValue()) {
                    this.fullSetNotified.put(uuid, true);
                    player.sendMessage(String.valueOf(ChatColor.AQUA) + "\u00bb " + String.valueOf(ChatColor.LIGHT_PURPLE) + "\u65e0\u5c3d\u76d4\u7532\u5df2\u6fc0\u6d3b\uff01");
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u00bb \u4f60\u83b7\u5f97\u4e86" + String.valueOf(ChatColor.GOLD) + "\u5b8c\u5168\u9632\u62a4");
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 0.5f, 2.0f);
                }
            } else {
                this.fullSetNotified.put(uuid, false);
            }
        });
    }

    private String createRainbowText(String text) {
        StringBuilder result = new StringBuilder();
        Color[] rainbowColors = new Color[]{new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(75, 0, 130), new Color(148, 0, 211)};
        for (int i = 0; i < text.length(); ++i) {
            Color color = rainbowColors[i % rainbowColors.length];
            result.append(net.md_5.bungee.api.ChatColor.of((Color)color)).append(text.charAt(i));
        }
        return result.toString();
    }

    private void removeDebuffs(Player player) {
        PotionEffectType[] debuffs;
        for (PotionEffectType debuff : debuffs = new PotionEffectType[]{PotionEffectType.SLOWNESS, PotionEffectType.MINING_FATIGUE, PotionEffectType.WEAKNESS, PotionEffectType.HUNGER, PotionEffectType.WITHER, PotionEffectType.POISON, PotionEffectType.LEVITATION, PotionEffectType.BLINDNESS, PotionEffectType.NAUSEA, PotionEffectType.INSTANT_DAMAGE}) {
            if (!player.hasPotionEffect(debuff)) continue;
            player.removePotionEffect(debuff);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDamage(EntityDamageEvent event) {
        int armorCount;
        boolean hasFullSet;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack helmet = player.getInventory().getHelmet();
        ItemStack chestplate = player.getInventory().getChestplate();
        ItemStack leggings = player.getInventory().getLeggings();
        ItemStack boots = player.getInventory().getBoots();
        boolean hasHelmet = "infinity_helmet".equals(PDCUtil.getItemId(helmet));
        boolean hasChestplate = "infinity_chestplate".equals(PDCUtil.getItemId(chestplate));
        boolean hasLeggings = "infinity_leggings".equals(PDCUtil.getItemId(leggings));
        boolean hasBoots = "infinity_boots".equals(PDCUtil.getItemId(boots));
        boolean bl = hasFullSet = hasHelmet && hasChestplate && hasLeggings && hasBoots;
        if (hasFullSet) {
            event.setCancelled(true);
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (this.isMagicDamage(cause) && (armorCount = (hasHelmet ? 1 : 0) + (hasChestplate ? 1 : 0) + (hasLeggings ? 1 : 0) + (hasBoots ? 1 : 0)) > 0) {
            double reduction = 0.2 * (double)armorCount;
            double damage = event.getDamage();
            event.setDamage(damage * (1.0 - reduction));
        }
    }

    private boolean isMagicDamage(EntityDamageEvent.DamageCause cause) {
        return cause == EntityDamageEvent.DamageCause.MAGIC || cause == EntityDamageEvent.DamageCause.WITHER || cause == EntityDamageEvent.DamageCause.POISON || cause == EntityDamageEvent.DamageCause.DRAGON_BREATH;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player attacker = (Player)event.getDamager();
        LivingEntity victim = (LivingEntity)event.getEntity();
        ItemStack weapon = attacker.getInventory().getItemInMainHand();
        String weaponId = PDCUtil.getItemId(weapon);
        if ("sword_of_the_cosmos".equals(weaponId)) {
            boolean victimHasFullSet = false;
            if (victim instanceof Player) {
                Player victimPlayer = (Player)victim;
                boolean bl = victimHasFullSet = "infinity_helmet".equals(PDCUtil.getItemId(victimPlayer.getInventory().getHelmet())) && "infinity_chestplate".equals(PDCUtil.getItemId(victimPlayer.getInventory().getChestplate())) && "infinity_leggings".equals(PDCUtil.getItemId(victimPlayer.getInventory().getLeggings())) && "infinity_boots".equals(PDCUtil.getItemId(victimPlayer.getInventory().getBoots()));
            }
            if (victimHasFullSet) {
                event.setCancelled(true);
                attacker.sendMessage(String.valueOf(ChatColor.RED) + "\u00bb \u5bf9\u65b9\u7a7f\u6234\u65e0\u5c3d\u76d4\u7532\uff0c\u514d\u75ab\u4f60\u7684\u653b\u51fb\uff01");
                ((Player)victim).sendMessage(String.valueOf(ChatColor.GREEN) + "\u00bb \u65e0\u5c3d\u76d4\u7532\u4fdd\u62a4\u4e86\u4f60\uff01");
                victim.getWorld().spawnParticle(Particle.ENCHANT, victim.getLocation().add(0.0, 1.0, 0.0), 50, 0.5, 0.5, 0.5, 0.0);
                victim.getWorld().playSound(victim.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 2.0f);
            } else {
                double killDamage = victim.getMaxHealth() + 1000.0;
                event.setDamage(killDamage);
                victim.getWorld().spawnParticle(Particle.SWEEP_ATTACK, victim.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
                victim.getWorld().spawnParticle(Particle.CRIT, victim.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.2);
                attacker.playSound(attacker.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 0.5f);
                if (victim instanceof Player) {
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        this.plugin.getLogger().info("[\u672b\u65e5\u4e4b\u5203] \u73a9\u5bb6 " + attacker.getName() + " \u4e00\u51fb\u51fb\u6740\u73a9\u5bb6 " + ((Player)victim).getName() + " (\u4f24\u5bb3: " + killDamage + ")");
                    }
                } else if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u672b\u65e5\u4e4b\u5203] \u73a9\u5bb6 " + attacker.getName() + " \u4e00\u51fb\u51fb\u6740 " + String.valueOf(victim.getType()) + " (\u4f24\u5bb3: " + killDamage + ", \u751f\u547d: " + victim.getHealth() + "/" + victim.getMaxHealth() + ")");
                }
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        boolean transferEnabled;
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        ItemStack mainHand = killer.getInventory().getItemInMainHand();
        ItemStack offHand = killer.getInventory().getItemInOffHand();
        String mainHandId = PDCUtil.getItemId(mainHand);
        String offHandId = PDCUtil.getItemId(offHand);
        boolean shouldDropHead = false;
        if ("skullfire_sword".equals(mainHandId)) {
            shouldDropHead = true;
        } else if ("skullfire_sword".equals(offHandId) && (transferEnabled = this.plugin.getConfig().getBoolean("infinity_tools.skullfire_offhand_transfer", true)) && mainHand != null && mainHand.getType() != Material.AIR) {
            shouldDropHead = true;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u9ab7\u9ac5\u5251] \u526f\u624b\u9ab7\u9ac5\u5251\u6548\u679c\u4f20\u9012\u7ed9\u4e3b\u624b " + String.valueOf(mainHand.getType()));
            }
        }
        if (!shouldDropHead) {
            return;
        }
        ItemStack skull = this.getMobHead(event.getEntityType());
        if (skull != null) {
            event.getDrops().add(skull);
            Location loc = event.getEntity().getLocation();
            loc.getWorld().spawnParticle(Particle.SOUL, loc, 20, 0.5, 0.5, 0.5, 0.05);
            killer.playSound(killer.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.3f, 2.0f);
        }
    }

    private ItemStack getMobHead(EntityType type) {
        Material headMaterial;
        switch (type) {
            case SKELETON: {
                headMaterial = Material.SKELETON_SKULL;
                break;
            }
            case WITHER_SKELETON: {
                headMaterial = Material.WITHER_SKELETON_SKULL;
                break;
            }
            case ZOMBIE: {
                headMaterial = Material.ZOMBIE_HEAD;
                break;
            }
            case CREEPER: {
                headMaterial = Material.CREEPER_HEAD;
                break;
            }
            case ENDER_DRAGON: {
                headMaterial = Material.DRAGON_HEAD;
                break;
            }
            case PLAYER: {
                return new ItemStack(Material.PLAYER_HEAD);
            }
            default: {
                ItemStack customHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta meta = (SkullMeta)customHead.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + type.name() + " Head");
                    customHead.setItemMeta((ItemMeta)meta);
                }
                return customHead;
            }
        }
        return new ItemStack(headMaterial);
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack bow = event.getBow();
        if (bow == null) {
            return;
        }
        String bowId = PDCUtil.getItemId(bow);
        if (!"infinity_bow".equals(bowId)) {
            return;
        }
        if (event.getProjectile() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getProjectile();
            arrow.setDamage(arrow.getDamage() * 3.0);
            arrow.setPierceLevel(5);
            arrow.setCritical(true);
            arrow.setCustomName("infinity_arrow");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.flyingPlayers.remove(uuid);
        this.fullSetNotified.remove(uuid);
    }
}

