/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class InfinityToolsListener
implements Listener {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final Map<UUID, Long> lastInteractTime = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> hammerMode = new HashMap<UUID, Boolean>();
    private final Map<UUID, ItemStack> infinityBowOffhandBackup = new HashMap<UUID, ItemStack>();

    public InfinityToolsListener(Avaritia_Plugin plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.startPickaxeSpeedTask();
    }

    private void startPickaxeSpeedTask() {
        FoliaUtil.runGlobalTimer(this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                ItemMeta meta;
                ItemStack item = player.getInventory().getItemInMainHand();
                String itemId = PDCUtil.getItemId(item);
                if (!"world_breaker".equals(itemId) || (meta = item.getItemMeta()) == null || meta.hasEnchant(Enchantment.EFFICIENCY) && meta.getEnchantLevel(Enchantment.EFFICIENCY) >= 10) continue;
                meta.addEnchant(Enchantment.EFFICIENCY, 10, true);
                item.setItemMeta(meta);
                if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
                this.plugin.getLogger().info("[\u4e16\u754c\u5d29\u89e3\u4e4b\u9550] \u4e3a\u73a9\u5bb6 " + player.getName() + " \u7684\u9550\u5b50\u6dfb\u52a0\u6548\u7387X");
            }
        }, 20L, 20L);
    }

    @EventHandler
    public void onWorldBreakerToggle(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (!"world_breaker".equals(itemId)) {
            return;
        }
        event.setCancelled(true);
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastInteractTime.get(player.getUniqueId());
        if (lastTime != null && currentTime - lastTime < 500L) {
            return;
        }
        this.lastInteractTime.put(player.getUniqueId(), currentTime);
        UUID uuid = player.getUniqueId();
        boolean isHammer = this.hammerMode.getOrDefault(uuid, false);
        this.hammerMode.put(uuid, !isHammer);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore;
            Integer newCMD = !isHammer ? this.plugin.getConfig().getInt("infinity_tools.hammer_cmd", 101) : 100;
            HashMap enchants = new HashMap(meta.getEnchants());
            boolean wasUnbreakable = meta.isUnbreakable();
            item.setItemMeta(meta);
            item = CustomModelDataUtil.setCustomModelData(item, String.valueOf(newCMD));
            meta = item.getItemMeta();
            if (meta == null) {
                this.plugin.getLogger().warning("[\u65e0\u5c3d\u9550] \u8bbe\u7f6eCMD\u540emeta\u4e3anull\uff01");
                return;
            }
            for (Map.Entry entry : enchants.entrySet()) {
                if (meta.hasEnchant((Enchantment)entry.getKey())) continue;
                meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            if (!meta.hasEnchant(Enchantment.EFFICIENCY) || meta.getEnchantLevel(Enchantment.EFFICIENCY) < 10) {
                meta.addEnchant(Enchantment.EFFICIENCY, 10, true);
            }
            if (wasUnbreakable) {
                meta.setUnbreakable(true);
            }
            if ((lore = meta.getLore()) == null) {
                lore = new ArrayList<String>();
            }
            lore.removeIf(line -> line.contains("\u5f53\u524d\u6a21\u5f0f") || line.contains("Current Mode"));
            if (!isHammer) {
                lore.add(String.valueOf(ChatColor.RED) + "\u00bb \u5f53\u524d\u6a21\u5f0f: \u9524\u5b50\u6a21\u5f0f");
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u00bb " + String.valueOf(ChatColor.YELLOW) + "\u5207\u6362\u5230" + String.valueOf(ChatColor.RED) + "\u9524\u5b50\u6a21\u5f0f" + String.valueOf(ChatColor.GRAY) + " - \u53ef\u7834\u574f16x16x16\u8303\u56f4");
                player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.2f);
            } else {
                lore.add(String.valueOf(ChatColor.AQUA) + "\u00bb \u5f53\u524d\u6a21\u5f0f: \u9550\u6a21\u5f0f");
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u00bb " + String.valueOf(ChatColor.YELLOW) + "\u5207\u6362\u5230" + String.valueOf(ChatColor.AQUA) + "\u9550\u6a21\u5f0f" + String.valueOf(ChatColor.GRAY) + " - \u6781\u901f\u6316\u6398");
                player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 2.0f);
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u4e16\u754c\u5d29\u89e3\u4e4b\u9550] \u73a9\u5bb6 " + player.getName() + " \u5207\u6362\u5230" + (!isHammer ? "\u9524\u5b50\u6a21\u5f0f" : "\u9550\u6a21\u5f0f") + ", CMD: " + newCMD + ", \u6548\u7387\u9644\u9b54: " + meta.getEnchantLevel(Enchantment.EFFICIENCY));
            }
        }
    }

    @EventHandler
    public void onMatterClusterThrow(ProjectileLaunchEvent event) {
        NamespacedKey itemsKey;
        ItemMeta meta;
        if (this.plugin.getConfig().getBoolean("debug", true) && event.getEntity() instanceof Snowball) {
            this.plugin.getLogger().info("[\u6295\u63b7\u7269] \u68c0\u6d4b\u5230\u96ea\u7403\u53d1\u5c04\u4e8b\u4ef6");
        }
        if (!(event.getEntity() instanceof Snowball)) {
            return;
        }
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity().getShooter();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        ItemStack item = null;
        boolean isMainHand = false;
        String mainHandId = PDCUtil.getItemId(mainHand);
        String offHandId = PDCUtil.getItemId(offHand);
        if ("matter_cluster".equals(mainHandId)) {
            item = mainHand;
            isMainHand = true;
        } else if ("matter_cluster".equals(offHandId)) {
            item = offHand;
            isMainHand = false;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            if (mainHand != null && mainHand.getType() == Material.SNOWBALL) {
                this.plugin.getLogger().info("[\u6295\u63b7\u7269] \u4e3b\u624b: " + mainHandId);
            }
            if (offHand != null && offHand.getType() == Material.SNOWBALL) {
                this.plugin.getLogger().info("[\u6295\u63b7\u7269] \u526f\u624b: " + offHandId);
            }
        }
        if (item == null) {
            return;
        }
        event.setCancelled(true);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u7269\u8d28\u56e2] \u62e6\u622a\u73a9\u5bb6 " + player.getName() + " \u6254\u51fa\u7269\u8d28\u56e2\uff0c\u6539\u4e3a\u91ca\u653e\u7269\u54c1");
        }
        if ((meta = item.getItemMeta()) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u00bb \u7269\u8d28\u56e2\u6570\u636e\u9519\u8bef");
            return;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String itemsData = (String)pdc.get(itemsKey = new NamespacedKey((Plugin)this.plugin, "stored_items"), PersistentDataType.STRING);
        if (itemsData == null || itemsData.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u00bb \u7269\u8d28\u56e2\u5185\u6ca1\u6709\u7269\u54c1");
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().warning("[\u7269\u8d28\u56e2] \u6ca1\u6709\u5b58\u50a8\u6570\u636e: " + itemsData);
            }
            return;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u7269\u8d28\u56e2] \u5b58\u50a8\u6570\u636e: " + itemsData);
        }
        String[] itemEntries = itemsData.split(";");
        int returnedCount = 0;
        for (String entry : itemEntries) {
            try {
                String[] parts;
                if (entry.trim().isEmpty() || (parts = entry.split(":")).length < 2) continue;
                Material material = Material.valueOf((String)parts[0]);
                int amount = Integer.parseInt(parts[1]);
                ItemStack returnItem = new ItemStack(material, amount);
                player.getWorld().dropItemNaturally(player.getLocation(), returnItem);
                returnedCount += amount;
                if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
                this.plugin.getLogger().info("[\u7269\u8d28\u56e2] \u6389\u843d: " + String.valueOf(material) + " x" + amount);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[\u7269\u8d28\u56e2] \u89e3\u6790\u7269\u54c1\u5931\u8d25: " + entry + " - " + e.getMessage());
            }
        }
        if (isMainHand) {
            mainHand.setAmount(mainHand.getAmount() - 1);
            player.getInventory().setItemInMainHand(mainHand);
        } else {
            offHand.setAmount(offHand.getAmount() - 1);
            player.getInventory().setItemInOffHand(offHand);
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u00bb \u7269\u8d28\u56e2\u5df2\u91ca\u653e\uff0c\u6389\u843d\u4e86 " + returnedCount + " \u4e2a\u7269\u54c1");
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 0.8f);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (itemId == null) {
            return;
        }
        Block block = event.getBlock();
        switch (itemId) {
            case "world_breaker": {
                this.handleWorldBreaker(event, player, block);
                break;
            }
            case "planet_heaver": {
                this.handlePlanetHeaver(event, player, block);
                break;
            }
            case "natures_ruin": {
                this.handleNaturesRuin(event, player, block);
            }
        }
    }

    private void handleWorldBreaker(BlockBreakEvent event, Player player, Block block) {
        boolean isHammer = this.hammerMode.getOrDefault(player.getUniqueId(), false);
        if (isHammer) {
            event.setCancelled(true);
            Location center = block.getLocation();
            World world = center.getWorld();
            boolean canBreakBedrock = this.plugin.getConfig().getBoolean("infinity_tools.hammer_break_bedrock", false);
            HashMap<Material, Integer> collectedItems = new HashMap<Material, Integer>();
            int broken = 0;
            int radius = 8;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block target = world.getBlockAt(center.getBlockX() + x, center.getBlockY() + y, center.getBlockZ() + z);
                        Material targetType = target.getType();
                        if (targetType == Material.AIR || targetType == Material.BEDROCK && !canBreakBedrock) continue;
                        Collection drops = target.getDrops(player.getInventory().getItemInMainHand());
                        for (ItemStack drop : drops) {
                            collectedItems.merge(drop.getType(), drop.getAmount(), Integer::sum);
                        }
                        target.setType(Material.AIR);
                        if (++broken >= 4096) break;
                    }
                    if (broken >= 4096) break;
                }
                if (broken >= 4096) break;
            }
            if (broken > 0) {
                ItemStack matterCluster = this.createMatterCluster(collectedItems);
                world.dropItemNaturally(center, matterCluster);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u00bb \u7834\u574f\u4e86 " + String.valueOf(ChatColor.YELLOW) + broken + String.valueOf(ChatColor.GRAY) + " \u4e2a\u65b9\u5757\uff0c\u6536\u96c6\u5230\u7269\u8d28\u56e2");
                player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.5f, 1.2f);
                world.spawnParticle(Particle.EXPLOSION_EMITTER, center, 3, 4.0, 4.0, 4.0, 0.0);
            }
        }
    }

    private ItemStack createMatterCluster(Map<Material, Integer> items) {
        ItemStack cluster = new ItemStack(Material.SNOWBALL);
        ItemMeta meta = (cluster = PDCUtil.addPluginData(cluster, "matter_cluster")).getItemMeta();
        if (meta == null) {
            this.plugin.getLogger().warning("[\u7269\u8d28\u56e2] \u65e0\u6cd5\u83b7\u53d6ItemMeta\uff01");
            return cluster;
        }
        String displayName = this.languageManager.getMessage("zh_cn", "items.matter_cluster.name", new Object[0]);
        if (!displayName.startsWith("Missing translation:")) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
        } else {
            meta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + "\u7269\u8d28\u56e2");
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NamespacedKey itemsKey = new NamespacedKey((Plugin)this.plugin, "stored_items");
        StringBuilder itemsData = new StringBuilder();
        for (Map.Entry<Material, Integer> entry : items.entrySet()) {
            if (itemsData.length() > 0) {
                itemsData.append(";");
            }
            itemsData.append(entry.getKey().name()).append(":").append(entry.getValue());
        }
        String itemsDataStr = itemsData.toString();
        pdc.set(itemsKey, PersistentDataType.STRING, (Object)itemsDataStr);
        NamespacedKey uuidKey = new NamespacedKey((Plugin)this.plugin, "cluster_uuid");
        pdc.set(uuidKey, PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
        ArrayList<Object> lore = new ArrayList<Object>();
        String loreLine = this.languageManager.getMessage("zh_cn", "items.matter_cluster.lore.0", new Object[0]);
        if (!loreLine.startsWith("Missing translation:")) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine));
        } else {
            lore.add(String.valueOf(ChatColor.GRAY) + "\u53f3\u952e\u91ca\u653e\u6240\u6709\u6536\u96c6\u7684\u7269\u54c1");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "\u5305\u542b " + String.valueOf(ChatColor.YELLOW) + items.size() + String.valueOf(ChatColor.GRAY) + " \u79cd\u7269\u54c1");
        int totalCount = items.values().stream().mapToInt(Integer::intValue).sum();
        lore.add(String.valueOf(ChatColor.GRAY) + "\u603b\u5171 " + String.valueOf(ChatColor.YELLOW) + totalCount + String.valueOf(ChatColor.GRAY) + " \u4e2a");
        meta.setLore(lore);
        cluster.setItemMeta(meta);
        cluster = CustomModelDataUtil.setCustomModelData(cluster, "102");
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            String detectedId = PDCUtil.getItemId(cluster);
            this.plugin.getLogger().info("[\u7269\u8d28\u56e2\u521b\u5efa] CMD: 102, \u7269\u54c1ID: " + detectedId + ", \u6570\u636e: " + itemsDataStr);
        }
        return cluster;
    }

    private void handlePlanetHeaver(BlockBreakEvent event, Player player, Block block) {
        event.setCancelled(true);
        Location center = block.getLocation();
        World world = center.getWorld();
        int broken = 0;
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    Block target = world.getBlockAt(center.getBlockX() + x, center.getBlockY() - y, center.getBlockZ() + z);
                    if (target.getType() == Material.AIR || target.getType() == Material.BEDROCK) continue;
                    Collection drops = target.getDrops(player.getInventory().getItemInMainHand());
                    target.setType(Material.AIR);
                    for (ItemStack drop : drops) {
                        world.dropItemNaturally(target.getLocation(), drop);
                    }
                    ++broken;
                }
            }
        }
        if (broken > 0) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u00bb \u6316\u6398\u4e86 " + String.valueOf(ChatColor.YELLOW) + broken + String.valueOf(ChatColor.GRAY) + " \u4e2a\u65b9\u5757");
        }
    }

    private void handleNaturesRuin(BlockBreakEvent event, Player player, Block block) {
        if (!block.getType().name().contains("LOG")) {
            return;
        }
        event.setCancelled(true);
        HashSet<Block> treeBlocks = new HashSet<Block>();
        this.findTreeBlocks(block, treeBlocks, 0);
        World world = block.getWorld();
        int broken = 0;
        for (Block treeBlock : treeBlocks) {
            Collection drops = treeBlock.getDrops(player.getInventory().getItemInMainHand());
            treeBlock.setType(Material.AIR);
            for (ItemStack drop : drops) {
                world.dropItemNaturally(treeBlock.getLocation(), drop);
            }
            ++broken;
        }
        if (broken > 0) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u00bb \u780d\u5012\u4e86\u4e00\u68f5\u6811\uff0c\u5171 " + String.valueOf(ChatColor.YELLOW) + broken + String.valueOf(ChatColor.GRAY) + " \u4e2a\u65b9\u5757");
            player.playSound(player.getLocation(), Sound.BLOCK_WOOD_BREAK, 1.0f, 0.8f);
        }
    }

    private void findTreeBlocks(Block block, Set<Block> found, int depth) {
        if (depth > 200 || found.size() > 500) {
            return;
        }
        if (found.contains(block)) {
            return;
        }
        Material type = block.getType();
        if (!type.name().contains("LOG") && !type.name().contains("LEAVES")) {
            return;
        }
        found.add(block);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Block neighbor = block.getRelative(x, y, z);
                    this.findTreeBlocks(neighbor, found, depth + 1);
                }
            }
        }
    }

    @EventHandler
    public void onInfinityBowUse(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack mainHand = event.getItem();
        if (mainHand == null || mainHand.getType() != Material.BOW) {
            return;
        }
        String itemId = PDCUtil.getItemId(mainHand);
        if (!"infinity_bow".equals(itemId)) {
            return;
        }
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (player.getInventory().contains(Material.ARROW) || offHand != null && offHand.getType() == Material.ARROW) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (offHand != null && offHand.getType() != Material.AIR) {
            this.infinityBowOffhandBackup.put(uuid, offHand.clone());
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u5907\u4efd\u73a9\u5bb6 " + player.getName() + " \u526f\u624b\u7269\u54c1: " + String.valueOf(offHand.getType()));
            }
        } else {
            this.infinityBowOffhandBackup.put(uuid, null);
        }
        player.getInventory().setItemInOffHand(new ItemStack(Material.ARROW, 1));
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u4e3a\u73a9\u5bb6 " + player.getName() + " \u4e34\u65f6\u66ff\u6362\u526f\u624b\u4e3a\u7bad");
        }
    }

    @EventHandler
    public void onInfinityBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack bow = event.getBow();
        if (bow == null) {
            return;
        }
        String bowId = PDCUtil.getItemId(bow);
        if (!"infinity_bow".equals(bowId)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        FoliaUtil.runEntityTaskLater(this.plugin, (Entity)player, () -> this.restoreOffhand(player, uuid), 1L);
    }

    @EventHandler
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.infinityBowOffhandBackup.containsKey(uuid)) {
            FoliaUtil.runEntityTaskLater(this.plugin, (Entity)player, () -> this.restoreOffhand(player, uuid), 1L);
        }
    }

    @EventHandler
    public void onSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        String mainHandId = PDCUtil.getItemId(mainHand);
        if ("infinity_bow".equals(mainHandId)) {
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u963b\u6b62\u73a9\u5bb6 " + player.getName() + " \u5207\u6362\u526f\u624b");
            }
            return;
        }
        if (this.infinityBowOffhandBackup.containsKey(uuid)) {
            ItemStack backup = this.infinityBowOffhandBackup.remove(uuid);
            event.setCancelled(true);
            if (backup != null && backup.getType() != Material.AIR) {
                player.getInventory().setItemInMainHand(backup);
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u73a9\u5bb6 " + player.getName() + " \u5207\u6362\u526f\u624b\uff0c\u6062\u590d\u7269\u54c1");
            }
        }
    }

    private void restoreOffhand(Player player, UUID uuid) {
        if (!this.infinityBowOffhandBackup.containsKey(uuid)) {
            return;
        }
        ItemStack backup = this.infinityBowOffhandBackup.remove(uuid);
        ItemStack currentOffhand = player.getInventory().getItemInOffHand();
        if (currentOffhand == null || currentOffhand.getType() == Material.AIR || currentOffhand.getType() == Material.ARROW) {
            if (backup != null && backup.getType() != Material.AIR) {
                player.getInventory().setItemInOffHand(backup);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u6062\u590d\u73a9\u5bb6 " + player.getName() + " \u526f\u624b\u7269\u54c1: " + String.valueOf(backup.getType()));
                }
            } else {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u65e0\u5c3d\u5f13] \u6e05\u7a7a\u73a9\u5bb6 " + player.getName() + " \u526f\u624b");
                }
            }
        } else if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().warning("[\u65e0\u5c3d\u5f13] \u526f\u624b\u5df2\u88ab " + String.valueOf(currentOffhand.getType()) + " \u5360\u7528\uff0c\u65e0\u6cd5\u6062\u590d\u5907\u4efd\u7684 " + String.valueOf(backup != null ? backup.getType() : "null"));
        }
    }

    @EventHandler
    public void onHoeUse(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (!"hoe_of_the_stars".equals(itemId)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material type = block.getType();
        if (type != Material.DIRT && type != Material.GRASS_BLOCK && type != Material.FARMLAND) {
            return;
        }
        event.setCancelled(true);
        Location center = block.getLocation();
        World world = center.getWorld();
        int radius = 4;
        int tilled = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Block above;
                Block target = world.getBlockAt(center.getBlockX() + x, center.getBlockY(), center.getBlockZ() + z);
                Material targetType = target.getType();
                if (targetType != Material.DIRT && targetType != Material.GRASS_BLOCK || (above = target.getRelative(0, 1, 0)).getType() != Material.AIR) continue;
                target.setType(Material.FARMLAND);
                ++tilled;
            }
        }
        if (tilled > 0) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u00bb \u8015\u5730\u4e86 " + String.valueOf(ChatColor.YELLOW) + tilled + String.valueOf(ChatColor.GRAY) + " \u4e2a\u65b9\u5757");
            player.playSound(player.getLocation(), Sound.ITEM_HOE_TILL, 1.0f, 1.0f);
        }
    }
}

