/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.util;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class CustomModelDataUtil {
    private static boolean isHighVersion = false;
    private static Logger logger;
    private static FileConfiguration config;
    private static boolean debugMode;
    private static boolean debugCustomModelData;

    public static void initialize(Logger pluginLogger, FileConfiguration pluginConfig) {
        logger = pluginLogger;
        config = pluginConfig;
        debugCustomModelData = debugMode = config.getBoolean("debug", true);
        if (logger != null && debugMode) {
            logger.info("CustomModelDataUtil\u5df2\u521d\u59cb\u5316 - " + (isHighVersion ? "\u9ad8\u7248\u672cAPI (1.21.4+)" : "\u4f20\u7edfAPI"));
        }
    }

    public static ItemStack setCustomModelData(ItemStack itemStack, Object modelData) {
        block25: {
            if (itemStack == null) {
                return null;
            }
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null) {
                return itemStack;
            }
            if (isHighVersion) {
                boolean intSuccess;
                boolean stringSuccess;
                block24: {
                    block23: {
                        stringSuccess = false;
                        intSuccess = false;
                        try {
                            CustomModelDataUtil.setLowVersionCustomModelData(meta, modelData);
                            intSuccess = true;
                            if (debugMode && logger != null) {
                                logger.info("\u2713 \u6210\u529f\u8bbe\u7f6eint\u7c7b\u578bCustomModelData: " + String.valueOf(modelData));
                            }
                        }
                        catch (Exception e) {
                            if (logger == null) break block23;
                            logger.warning("\u2717 int\u7c7b\u578bCustomModelData\u8bbe\u7f6e\u5931\u8d25: " + e.getMessage());
                        }
                    }
                    if (intSuccess) {
                        itemStack.setItemMeta(meta);
                        meta = itemStack.getItemMeta();
                        if (meta == null) {
                            if (logger != null) {
                                logger.severe("\u2717 \u5e94\u7528int\u7c7b\u578b\u540emeta\u53d8\u4e3anull");
                            }
                            return itemStack;
                        }
                        try {
                            String originalStringValue = modelData instanceof String ? (String)modelData : String.valueOf(modelData);
                            CustomModelDataComponent component = meta.getCustomModelDataComponent();
                            if (component != null) {
                                component.setStrings(Collections.singletonList(originalStringValue));
                                meta.setCustomModelDataComponent(component);
                                stringSuccess = true;
                                if (debugMode && logger != null) {
                                    logger.info("\u2713 \u6210\u529f\u8bbe\u7f6eString\u7c7b\u578bCustomModelData: \"" + originalStringValue + "\"");
                                }
                            } else if (debugMode && logger != null) {
                                logger.warning("\u2717 \u5e94\u7528int\u540ecomponent\u4ecd\u4e3anull\uff0c\u53ef\u80fd\u670d\u52a1\u5668\u7248\u672c\u4e0d\u652f\u6301CustomModelDataComponent");
                            }
                        }
                        catch (Exception e) {
                            if (!debugMode || logger == null) break block24;
                            logger.warning("\u2717 String\u7c7b\u578bCustomModelData\u8bbe\u7f6e\u5931\u8d25: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                if (stringSuccess || intSuccess) {
                    itemStack.setItemMeta(meta);
                    if (logger != null) {
                        logger.info("\u2705 CustomModelData\u8bbe\u7f6e\u5b8c\u6210 - String: " + stringSuccess + ", Int: " + intSuccess);
                    }
                } else if (logger != null) {
                    logger.severe("\u274c \u65e0\u6cd5\u8bbe\u7f6e\u4efb\u4f55\u7c7b\u578b\u7684CustomModelData");
                }
            } else {
                try {
                    CustomModelDataUtil.setLowVersionCustomModelData(meta, modelData);
                    itemStack.setItemMeta(meta);
                    if (debugMode && logger != null) {
                        logger.info("\u2713 \u6210\u529f\u8bbe\u7f6eCustomModelData: " + String.valueOf(modelData));
                    }
                }
                catch (Exception e) {
                    if (logger == null) break block25;
                    logger.severe("\u2717 \u65e0\u6cd5\u8bbe\u7f6eCustomModelData: " + e.getMessage());
                }
            }
        }
        return itemStack;
    }

    private static void setHighVersionCustomModelData(ItemMeta meta, Object modelData) throws Exception {
        block5: {
            String stringValue = modelData instanceof String ? (String)modelData : (modelData instanceof Integer ? String.valueOf(modelData) : modelData.toString());
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (component != null) {
                    component.setStrings(Collections.singletonList(stringValue));
                    meta.setCustomModelDataComponent(component);
                    if (debugMode && logger != null) {
                        logger.info("\u6210\u529f\u8bbe\u7f6eString\u7c7b\u578bCustomModelData: " + stringValue);
                    }
                    break block5;
                }
                if (debugMode && logger != null) {
                    logger.info("CustomModelDataComponent\u4e3anull\uff0c\u8df3\u8fc7String\u7c7b\u578b\u8bbe\u7f6e\uff0c\u4f9d\u8d56int\u7c7b\u578b\u517c\u5bb9");
                }
                throw new Exception("CustomModelDataComponent\u7ec4\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u7f6eString\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new Exception("\u8bbe\u7f6e\u9ad8\u7248\u672cCustomModelData\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private static void setLowVersionCustomModelData(ItemMeta meta, Object modelData) throws Exception {
        int intValue;
        if (modelData instanceof Integer) {
            intValue = (Integer)modelData;
        } else if (modelData instanceof String) {
            try {
                intValue = Integer.parseInt((String)modelData);
            }
            catch (NumberFormatException e) {
                intValue = modelData.hashCode();
            }
        } else {
            intValue = modelData.hashCode();
        }
        meta.setCustomModelData(Integer.valueOf(intValue));
    }

    public static Object getCustomModelData(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (isHighVersion) {
            try {
                Object stringData = CustomModelDataUtil.getHighVersionCustomModelData(meta);
                if (stringData != null) {
                    return stringData;
                }
            }
            catch (Exception stringData) {
                // empty catch block
            }
            try {
                return CustomModelDataUtil.getLowVersionCustomModelData(meta);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return CustomModelDataUtil.getLowVersionCustomModelData(meta);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getHighVersionCustomModelData(ItemMeta meta) throws Exception {
        try {
            List strings;
            CustomModelDataComponent component = meta.getCustomModelDataComponent();
            if (component != null && (strings = component.getStrings()) != null && !strings.isEmpty()) {
                return strings.get(0);
            }
        }
        catch (Exception e) {
            if (debugMode && logger != null) {
                logger.fine("\u83b7\u53d6String\u7c7b\u578bCustomModelData\u5931\u8d25: " + e.getMessage());
            }
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u9ad8\u7248\u672cCustomModelData: " + e.getMessage());
        }
        return null;
    }

    private static Object getLowVersionCustomModelData(ItemMeta meta) throws Exception {
        if (meta.hasCustomModelData()) {
            return meta.getCustomModelData();
        }
        return null;
    }

    public static boolean isHighVersion() {
        return isHighVersion;
    }

    public static boolean isNewApiSupported() {
        return isHighVersion;
    }

    public static String getCustomModelDataString(ItemStack itemStack) {
        if (itemStack == null || !isHighVersion) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        try {
            Object stringData = CustomModelDataUtil.getHighVersionCustomModelData(meta);
            if (stringData instanceof String) {
                return (String)stringData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getCustomModelDataInt(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return 0;
        }
        try {
            Object intData = CustomModelDataUtil.getLowVersionCustomModelData(meta);
            if (intData instanceof Integer) {
                return (Integer)intData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    static {
        debugMode = false;
        debugCustomModelData = false;
        try {
            Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
            isHighVersion = true;
        }
        catch (ClassNotFoundException e) {
            isHighVersion = false;
        }
    }
}

