/*
 * Decompiled with CFR 0.152.
 */
package com.marilynje.goatexpansion.items.custom;

import com.marilynje.goatexpansion.items.ModItems;
import com.marilynje.goatexpansion.utils.ModIdentifier;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7430;
import net.minecraft.class_8779;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class CooperHorn
extends class_7430 {
    private static final String NBT_PROGRESS = "OxidationProgress";
    private static final String NBT_SOUND_INDEX = "SoundIndex";
    private static final class_3414[] HORN_SOUNDS = new class_3414[]{class_3414.method_47908((class_2960)class_2960.method_60655((String)ModIdentifier.MOD_ID, (String)"copper_horn.memory")), class_3414.method_47908((class_2960)class_2960.method_60655((String)ModIdentifier.MOD_ID, (String)"copper_horn.resting")), class_3414.method_47908((class_2960)class_2960.method_60655((String)ModIdentifier.MOD_ID, (String)"copper_horn.thought"))};
    private static final String[] MELODY_NAMES = new String[]{"melody.goatexpansion.memory", "melody.goatexpansion.resting", "melody.goatexpansion.thought"};

    public CooperHorn(class_1792.class_1793 settings) {
        super(settings);
    }

    public static String getMelodyName(int index) {
        if (index >= 0 && index < MELODY_NAMES.length) {
            return MELODY_NAMES[index];
        }
        return MELODY_NAMES[0];
    }

    public static int getOxidation(class_1799 stack) {
        if (stack.method_31574(ModItems.COOPER_HORN) || stack.method_31574(ModItems.COPPER_HORN_WAXED)) {
            return 0;
        }
        if (stack.method_31574(ModItems.COPPER_HORN_EXPOSED) || stack.method_31574(ModItems.COPPER_HORN_EXPOSED_WAXED)) {
            return 1;
        }
        if (stack.method_31574(ModItems.COPPER_HORN_WEATHERED) || stack.method_31574(ModItems.COPPER_HORN_WEATHERED_WAXED)) {
            return 2;
        }
        if (stack.method_31574(ModItems.COPPER_HORN_OXIDIZED) || stack.method_31574(ModItems.COPPER_HORN_OXIDIZED_WAXED)) {
            return 3;
        }
        return 0;
    }

    public static boolean isWaxed(class_1799 stack) {
        return stack.method_31574(ModItems.COPPER_HORN_WAXED) || stack.method_31574(ModItems.COPPER_HORN_EXPOSED_WAXED) || stack.method_31574(ModItems.COPPER_HORN_WEATHERED_WAXED) || stack.method_31574(ModItems.COPPER_HORN_OXIDIZED_WAXED);
    }

    public static float getOxidationProgress(class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_58694(class_9334.field_49628);
        class_2487 tag = comp != null ? comp.method_57461() : new class_2487();
        return tag.method_10545(NBT_PROGRESS) ? tag.method_10583(NBT_PROGRESS).orElse(Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    public static void setOxidationProgress(class_1799 stack, float value) {
        class_9279 comp = (class_9279)stack.method_58694(class_9334.field_49628);
        class_2487 tag = comp != null ? comp.method_57461() : new class_2487();
        tag.method_10548(NBT_PROGRESS, Math.max(0.0f, Math.min(1.0f, value)));
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static int getSoundIndex(class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_58694(class_9334.field_49628);
        class_2487 tag = comp != null ? comp.method_57461() : new class_2487();
        return tag.method_10545(NBT_SOUND_INDEX) ? tag.method_10550(NBT_SOUND_INDEX).orElse(0) : 0;
    }

    public static void setSoundIndex(class_1799 stack, int index) {
        class_9279 comp = (class_9279)stack.method_58694(class_9334.field_49628);
        class_2487 tag = comp != null ? comp.method_57461() : new class_2487();
        tag.method_10569(NBT_SOUND_INDEX, index);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    private static class_1799 createHornWithProgress(class_1799 newStack, class_1799 current) {
        if (newStack != null) {
            float progress = CooperHorn.getOxidationProgress(current);
            CooperHorn.setOxidationProgress(newStack, progress);
        }
        return newStack;
    }

    public static class_1799 createLessOxidizedHorn(class_1799 current, int newOxidationLevel) {
        boolean wasWaxed = CooperHorn.isWaxed(current);
        class_1799 newStack = switch (newOxidationLevel) {
            case 0 -> new class_1799((class_1935)(wasWaxed ? ModItems.COPPER_HORN_WAXED : ModItems.COOPER_HORN), current.method_7947());
            case 1 -> new class_1799((class_1935)(wasWaxed ? ModItems.COPPER_HORN_EXPOSED_WAXED : ModItems.COPPER_HORN_EXPOSED), current.method_7947());
            case 2 -> new class_1799((class_1935)(wasWaxed ? ModItems.COPPER_HORN_WEATHERED_WAXED : ModItems.COPPER_HORN_WEATHERED), current.method_7947());
            default -> null;
        };
        return CooperHorn.createHornWithProgress(newStack, current);
    }

    public static class_1799 createUnwaxedHorn(class_1799 current, int oxidationLevel) {
        class_1799 newStack = switch (oxidationLevel) {
            case 0 -> new class_1799((class_1935)ModItems.COOPER_HORN, current.method_7947());
            case 1 -> new class_1799((class_1935)ModItems.COPPER_HORN_EXPOSED, current.method_7947());
            case 2 -> new class_1799((class_1935)ModItems.COPPER_HORN_WEATHERED, current.method_7947());
            case 3 -> new class_1799((class_1935)ModItems.COPPER_HORN_OXIDIZED, current.method_7947());
            default -> null;
        };
        return CooperHorn.createHornWithProgress(newStack, current);
    }

    public static class_1799 createWaxedHorn(class_1799 current) {
        int oxidationLevel = CooperHorn.getOxidation(current);
        class_1799 newStack = switch (oxidationLevel) {
            case 0 -> new class_1799((class_1935)ModItems.COPPER_HORN_WAXED, current.method_7947());
            case 1 -> new class_1799((class_1935)ModItems.COPPER_HORN_EXPOSED_WAXED, current.method_7947());
            case 2 -> new class_1799((class_1935)ModItems.COPPER_HORN_WEATHERED_WAXED, current.method_7947());
            case 3 -> new class_1799((class_1935)ModItems.COPPER_HORN_OXIDIZED_WAXED, current.method_7947());
            default -> null;
        };
        return CooperHorn.createHornWithProgress(newStack, current);
    }

    public static void spawnParticlesAtOffHand(class_3218 world, class_1657 user, class_2394 particleType) {
        double yaw = Math.toRadians(user.method_36454());
        double x = user.method_23317() - Math.sin(yaw) * 0.3;
        double y = user.method_23318() + (double)user.method_5751() * 0.65;
        double z = user.method_23321() + Math.cos(yaw) * 0.3;
        world.method_65096(particleType, x, y, z, 8, 0.2, 0.2, 0.2, 0.05);
    }

    public static void grantAdvancement(class_3218 world, class_3222 player, String advancementId, String criterion) {
        class_2989 advancementLoader = world.method_8503().method_3851();
        class_8779 advancementEntry = advancementLoader.method_12896(class_2960.method_60655((String)"minecraft", (String)advancementId));
        if (advancementEntry != null) {
            player.method_14236().method_12878(advancementEntry, criterion);
        }
    }

    public static class_3414[] getHornSounds() {
        return HORN_SOUNDS;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 component, Consumer<class_2561> tooltip, class_1836 type) {
        super.method_67187(stack, context, component, tooltip, type);
        int soundIndex = CooperHorn.getSoundIndex(stack);
        String melodyKey = CooperHorn.getMelodyName(soundIndex);
        class_5250 melodyText = class_2561.method_43471((String)melodyKey).method_27694(style -> style.method_27703(class_5251.method_27717((int)0xAAAAAA)));
        tooltip.accept((class_2561)melodyText);
        class_5250 switchHint = class_2561.method_43471((String)"tooltip.goatexpansion.copper_horn.switch_melody").method_27694(style -> style.method_27703(class_5251.method_27717((int)0x808080)));
        tooltip.accept((class_2561)switchHint);
    }
}

