/*
 * Decompiled with CFR 0.152.
 */
package com.marilynje.goatexpansion.mixin;

import com.marilynje.goatexpansion.access.LivingEntityHornSoundHolder;
import com.marilynje.goatexpansion.items.custom.CooperHorn;
import com.marilynje.goatexpansion.utils.HornSoundRegistry;
import com.marilynje.goatexpansion.utils.HornUtils;
import com.marilynje.goatexpansion.utils.ModIdentifier;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_7058;
import net.minecraft.class_7260;
import net.minecraft.class_7430;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7430.class})
public class GoatHornItemMixin {
    @Unique
    private static void setSharedHornCooldown(class_1657 user, int duration) {
        class_1796 cooldowns = user.method_7357();
        class_1799 current = user.method_6047();
        if (!current.method_7960()) {
            cooldowns.method_62835(current, duration);
        }
        for (class_1799 horn : HornUtils.getAllHorns()) {
            cooldowns.method_62835(horn, duration);
        }
    }

    @Unique
    private static void handleHornInteraction(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, class_1799 mainHand, CallbackInfoReturnable<class_1269> cir) {
        if (mainHand.method_31574(class_1802.field_20414) && !CooperHorn.isWaxed(stack)) {
            class_1799 newHornStack = CooperHorn.createWaxedHorn(stack);
            if (newHornStack != null) {
                user.method_6122(hand, newHornStack);
                world.method_8396(null, user.method_24515(), class_3417.field_29543, class_3419.field_15248, 1.0f, 1.0f);
                if (!user.method_31549().field_7477) {
                    mainHand.method_7934(1);
                }
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    if (user instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)user;
                        CooperHorn.spawnParticlesAtOffHand(serverWorld, user, (class_2394)class_2398.field_29642);
                        CooperHorn.grantAdvancement(serverWorld, serverPlayer, "husbandry/wax_on", "wax_on");
                    }
                }
                cir.setReturnValue((Object)class_1269.field_5812);
                cir.cancel();
            }
            return;
        }
        if (mainHand.method_31573(class_3489.field_42612)) {
            if (CooperHorn.isWaxed(stack)) {
                class_1799 newHornStack = CooperHorn.createUnwaxedHorn(stack, CooperHorn.getOxidation(stack));
                if (newHornStack != null) {
                    user.method_6122(hand, newHornStack);
                    world.method_8396(null, user.method_24515(), class_3417.field_29542, class_3419.field_15248, 1.0f, 1.0f);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        if (user instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)user;
                            CooperHorn.spawnParticlesAtOffHand(serverWorld, user, (class_2394)class_2398.field_29643);
                            CooperHorn.grantAdvancement(serverWorld, serverPlayer, "husbandry/wax_off", "wax_off");
                        }
                    }
                    cir.setReturnValue((Object)class_1269.field_5812);
                    cir.cancel();
                }
            } else {
                class_1799 newHornStack;
                int level = CooperHorn.getOxidation(stack);
                if (level > 0 && (newHornStack = CooperHorn.createLessOxidizedHorn(stack, level - 1)) != null) {
                    user.method_6122(hand, newHornStack);
                    world.method_8396(null, user.method_24515(), class_3417.field_29541, class_3419.field_15248, 1.0f, 1.0f);
                    cir.setReturnValue((Object)class_1269.field_5812);
                    cir.cancel();
                }
            }
        }
    }

    @Unique
    private static void setHornSoundId(class_1657 user, class_1799 stack) {
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            class_2960 hornId = HornSoundRegistry.getHornSoundIdentifier(stack);
            ((LivingEntityHornSoundHolder)serverPlayer).setCurrentHornSoundId(hornId);
        }
    }

    @Unique
    private static float getPitchByOxidation(class_1799 stack) {
        return switch (CooperHorn.getOxidation(stack)) {
            case 1 -> 0.95f;
            case 2 -> 0.9f;
            case 3 -> 0.85f;
            default -> 1.0f;
        };
    }

    @Unique
    private static void maybeTriggerWarden(class_1937 world, class_1657 user, class_1799 stack) {
        if (world.method_8608()) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (user.method_7357().method_7904(stack)) {
            return;
        }
        class_5321 ancientCityKey = class_7058.field_38428;
        Optional structureRegistryOpt = serverWorld.method_30349().method_46759(class_7924.field_41246);
        if (structureRegistryOpt.isEmpty()) {
            return;
        }
        class_2378 structureRegistry = (class_2378)structureRegistryOpt.get();
        class_3195 ancientCity = (class_3195)structureRegistry.method_29107(ancientCityKey);
        if (ancientCity == null) {
            return;
        }
        class_3449 structureStart = serverWorld.method_27056().method_28388(user.method_24515(), ancientCity);
        if (structureStart == null || !structureStart.method_16657()) {
            return;
        }
        class_2338 playerPos = user.method_24515();
        class_7260 warden = null;
        int attempts = 10;
        for (int i = 0; i < attempts; ++i) {
            class_2338 spawnPos = playerPos.method_10069(-6 + serverWorld.field_9229.method_43048(13), 0, -6 + serverWorld.field_9229.method_43048(13));
            class_7260 testWarden = (class_7260)class_1299.field_38095.method_5888(serverWorld, null, spawnPos, class_3730.field_16461, true, false);
            if (testWarden == null || !serverWorld.method_8587((class_1297)testWarden, testWarden.method_5829())) continue;
            warden = testWarden;
            break;
        }
        if (warden != null) {
            serverWorld.method_8649(warden);
        }
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            class_2989 advancementLoader = serverWorld.method_8503().method_3851();
            class_8779 advancementEntry = advancementLoader.method_12896(ModIdentifier.of("adventure/shouldnt_do_that"));
            if (advancementEntry != null) {
                serverPlayer.method_14236().method_12878(advancementEntry, "impossible");
            }
        }
        user.method_6092(new class_1293(class_1294.field_38092, 200, 0));
    }

    @Inject(method={"getMaxUseTime"}, at={@At(value="HEAD")}, cancellable=true)
    private void setMaxUseTime(class_1799 stack, class_1309 user, CallbackInfoReturnable<Integer> cir) {
        int duration = HornSoundRegistry.getHornDuration(stack);
        cir.setReturnValue((Object)duration);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleHornUse(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608()) {
            GoatHornItemMixin.maybeTriggerWarden(world, user, stack);
        }
        if (stack == null || stack.method_7960() || !(stack.method_7909() instanceof CooperHorn)) {
            return;
        }
        if (!world.method_8608() && hand == class_1268.field_5810) {
            GoatHornItemMixin.handleHornInteraction(world, user, hand, stack, user.method_6047(), cir);
            if (cir.getReturnValue() == class_1269.field_5812) {
                return;
            }
        }
        if (user.method_5715()) {
            int currentIndex = CooperHorn.getSoundIndex(stack);
            CooperHorn.setSoundIndex(stack, (currentIndex + 1) % 3);
            cir.setReturnValue((Object)class_1269.field_5812);
            cir.cancel();
            return;
        }
        if (!user.method_5715() && hand == class_1268.field_5808 && !world.method_8608()) {
            class_3414[] hornSounds = CooperHorn.getHornSounds();
            int idx = CooperHorn.getSoundIndex(stack);
            if (idx < 0 || idx >= hornSounds.length) {
                idx = ThreadLocalRandom.current().nextInt(hornSounds.length);
                CooperHorn.setSoundIndex(stack, idx);
            }
            world.method_8396(null, user.method_24515(), hornSounds[idx], class_3419.field_15248, 1.0f, GoatHornItemMixin.getPitchByOxidation(stack));
            GoatHornItemMixin.setHornSoundId(user, stack);
            user.method_6019(hand);
            GoatHornItemMixin.setSharedHornCooldown(user, HornSoundRegistry.getHornDuration(stack));
            cir.setReturnValue((Object)class_1269.field_21466);
            cir.cancel();
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN")}, cancellable=true)
    private void makeContinuousUse(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_2960 soundEventId;
        class_1799 usedStack;
        if (world.method_8608() || cir.getReturnValue() == class_1269.field_5814) {
            return;
        }
        if (cir.getReturnValue() != class_1269.field_21466) {
            user.method_6019(hand);
            cir.setReturnValue((Object)class_1269.field_21466);
        }
        if ((usedStack = user.method_5998(hand)).method_7960() || !(usedStack.method_7909() instanceof class_7430)) {
            return;
        }
        GoatHornItemMixin.setSharedHornCooldown(user, HornSoundRegistry.getHornDuration(usedStack));
        if (!(usedStack.method_7909() instanceof CooperHorn) && (soundEventId = HornSoundRegistry.getHornSoundEventId(usedStack)) != null) {
            ((LivingEntityHornSoundHolder)user).setCurrentHornSoundId(soundEventId);
        }
    }
}

