/*
 * Decompiled with CFR 0.152.
 */
package com.marilynje.goatexpansion.mixin;

import com.marilynje.goatexpansion.items.ModItems;
import com.marilynje.goatexpansion.items.custom.CooperHorn;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityOxidationMixin {
    @Unique
    private static final String NBT_PROGRESS = "OxidationProgress";
    @Unique
    private static final float BASE_TICKS_PER_STAGE = 12000.0f;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_6979(class_1799 var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void oxidizeCopperHorn(CallbackInfo ci) {
        class_1542 self = (class_1542)this;
        if (self.method_73183().method_8608()) {
            return;
        }
        class_1937 class_19372 = self.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_1799 stack = this.method_6983();
        if (stack.method_7960()) {
            return;
        }
        if (!(stack.method_7909() instanceof CooperHorn)) {
            return;
        }
        if (CooperHorn.isWaxed(stack)) {
            return;
        }
        float speed = ItemEntityOxidationMixin.getSpeedMultiplier(world, self);
        if (speed <= 0.0f) {
            return;
        }
        float increment = 8.333333E-5f * speed;
        float progress = ItemEntityOxidationMixin.getProgress(stack) + increment;
        if (progress >= 1.0f) {
            int level = CooperHorn.getOxidation(stack);
            if (level < 3) {
                class_1799 newStack = ItemEntityOxidationMixin.createNextHornStack(stack, level + 1);
                ItemEntityOxidationMixin.setProgress(newStack, 0.0f);
                class_1542 newEntity = new class_1542((class_1937)world, self.method_23317(), self.method_23318(), self.method_23321(), newStack);
                newEntity.method_18799(self.method_18798());
                world.method_8649((class_1297)newEntity);
                self.method_31472();
                return;
            }
            ItemEntityOxidationMixin.setProgress(stack, 1.0f);
        } else {
            ItemEntityOxidationMixin.setProgress(stack, progress);
        }
    }

    @Unique
    private static class_1799 createNextHornStack(class_1799 current, int nextLevel) {
        boolean waxed = CooperHorn.isWaxed(current);
        if (waxed) {
            return current.method_7972();
        }
        class_1799 next = switch (nextLevel) {
            case 1 -> new class_1799((class_1935)ModItems.COPPER_HORN_EXPOSED, current.method_7947());
            case 2 -> new class_1799((class_1935)ModItems.COPPER_HORN_WEATHERED, current.method_7947());
            case 3 -> new class_1799((class_1935)ModItems.COPPER_HORN_OXIDIZED, current.method_7947());
            default -> current.method_7972();
        };
        ItemEntityOxidationMixin.setProgress(next, 0.0f);
        return next;
    }

    @Unique
    private static float getSpeedMultiplier(class_3218 world, class_1542 entity) {
        if (entity.method_5869() || entity.method_5799()) {
            return 2.0f;
        }
        class_2338 pos = entity.method_24515();
        boolean raining = world.method_8419() && world.method_22348(pos);
        return raining ? 1.5f : 1.0f;
    }

    @Unique
    private static float getProgress(class_1799 stack) {
        class_2487 tag = ItemEntityOxidationMixin.getOrCreateCustomData(stack);
        return tag.method_10545(NBT_PROGRESS) ? tag.method_10583(NBT_PROGRESS).orElse(Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    @Unique
    private static void setProgress(class_1799 stack, float value) {
        class_2487 tag = ItemEntityOxidationMixin.getOrCreateCustomData(stack);
        tag.method_10548(NBT_PROGRESS, Math.max(0.0f, Math.min(1.0f, value)));
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    @Unique
    private static class_2487 getOrCreateCustomData(class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_58694(class_9334.field_49628);
        return comp != null ? comp.method_57461() : new class_2487();
    }
}

