/*
 * Decompiled with CFR 0.152.
 */
package com.marilynje.goatexpansion.mixin;

import com.marilynje.goatexpansion.access.LivingEntityHornSoundHolder;
import com.marilynje.goatexpansion.utils.HornUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7430;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements LivingEntityHornSoundHolder {
    @Shadow
    protected int field_6222;
    @Unique
    private boolean allowStopUsingItem = false;
    @Unique
    private class_2960 currentHornSoundId = null;
    @Unique
    private int savedAirBeforeBaseTick = -1;
    @Unique
    private int drowningTickCounter = 0;
    @Unique
    private static final int HORN_AIR_CONSUMPTION_PER_TICK = 2;

    @Shadow
    public abstract class_1799 method_6030();

    @Override
    @Unique
    public void setCurrentHornSoundId(class_2960 soundId) {
        this.currentHornSoundId = soundId;
    }

    @Override
    @Unique
    public class_2960 getCurrentHornSoundId() {
        return this.currentHornSoundId;
    }

    @Unique
    private boolean isUsingHorn() {
        class_1799 activeItem = this.method_6030();
        return activeItem != null && !activeItem.method_7960() && activeItem.method_7909() instanceof class_7430 && this.field_6222 > 0;
    }

    @Unique
    private boolean hasActiveHorn() {
        class_1799 activeItem = this.method_6030();
        return activeItem != null && activeItem.method_7909() instanceof class_7430;
    }

    @Unique
    private void stopHornAndResetCooldown(class_1309 entity) {
        this.allowStopUsingItem = true;
        entity.method_6075();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.resetAllHornCooldowns(player);
        }
    }

    @Unique
    private void stopHornSound(class_3222 serverPlayer) {
        if (this.currentHornSoundId != null) {
            serverPlayer.field_13987.method_14364((class_2596)new class_2770(this.currentHornSoundId, null));
            this.currentHornSoundId = null;
        }
    }

    @Inject(method={"stopUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopUsingHorn(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (!this.isUsingHorn() && !this.hasActiveHorn()) {
            this.allowStopUsingItem = false;
            return;
        }
        if (this.allowStopUsingItem && this.hasActiveHorn()) {
            if (!entity.method_73183().method_8608() && entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                this.stopHornSound(serverPlayer);
            }
            this.allowStopUsingItem = false;
            return;
        }
        if (this.hasActiveHorn() && this.field_6222 > 0) {
            ci.cancel();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void stopHornOnDeath(class_1282 damageSource, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (this.hasActiveHorn()) {
            this.stopHornAndResetCooldown(entity);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void saveAirBeforeBaseTick(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_73183().method_8608()) {
            return;
        }
        this.savedAirBeforeBaseTick = this.isUsingHorn() ? entity.method_5669() : -1;
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void simulateUnderwaterMechanics(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_73183().method_8608() || !this.isUsingHorn()) {
            this.savedAirBeforeBaseTick = -1;
            this.drowningTickCounter = 0;
            return;
        }
        int currentAir = entity.method_5669();
        if (this.savedAirBeforeBaseTick >= 0 && currentAir > this.savedAirBeforeBaseTick) {
            entity.method_5855(this.savedAirBeforeBaseTick);
            currentAir = this.savedAirBeforeBaseTick;
        }
        int nextAir = currentAir - 2;
        boolean crossesZeroNow = currentAir > 0 && nextAir <= 0;
        boolean wasAtZero = currentAir == 0;
        entity.method_5855(nextAir);
        if (nextAir > 0) {
            this.drowningTickCounter = 0;
        } else if (crossesZeroNow || wasAtZero) {
            this.drowningTickCounter = 1;
            this.dealDrowningDamage(entity);
        } else {
            ++this.drowningTickCounter;
            if (this.drowningTickCounter >= 20) {
                this.dealDrowningDamage(entity);
                this.drowningTickCounter = 0;
            }
        }
        if (entity.method_5669() <= -20) {
            this.drowningTickCounter = 0;
            this.stopHornAndResetCooldown(entity);
        }
    }

    @Unique
    private void dealDrowningDamage(class_1309 entity) {
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1282 damageSource = serverWorld.method_48963().method_48824();
            entity.method_64397(serverWorld, damageSource, 2.0f);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void stopHornOnDamage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        if (this.hasActiveHorn()) {
            this.stopHornAndResetCooldown(entity);
        }
    }

    @Unique
    private void resetAllHornCooldowns(class_1657 player) {
        class_1796 cooldowns = player.method_7357();
        for (class_1799 horn : HornUtils.getAllHorns()) {
            cooldowns.method_62835(horn, 0);
        }
    }
}

