/*
 * Decompiled with CFR 0.152.
 */
package com.marilynje.goatexpansion.utils;

import com.marilynje.goatexpansion.items.custom.CooperHorn;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10710;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9334;

public class HornSoundRegistry {
    private static final Map<String, Integer> HORN_REGISTRY = new HashMap<String, Integer>();
    private static final Map<String, String> INSTRUMENT_TO_SOUND = new HashMap<String, String>();

    private static void registerHorn(String soundId, int duration) {
        HORN_REGISTRY.put(soundId, duration);
    }

    public static int getHornDuration(class_1799 stack) {
        String soundId = HornSoundRegistry.getHornSoundId(stack);
        if (soundId != null && HORN_REGISTRY.containsKey(soundId)) {
            return HORN_REGISTRY.get(soundId);
        }
        return 100;
    }

    public static class_2960 getHornSoundIdentifier(class_1799 stack) {
        String soundId = HornSoundRegistry.getHornSoundId(stack);
        return soundId != null ? class_2960.method_12829((String)soundId) : null;
    }

    public static class_2960 getHornSoundEventId(class_1799 stack) {
        String soundEventId;
        if (stack.method_7909() instanceof CooperHorn) {
            return HornSoundRegistry.getHornSoundIdentifier(stack);
        }
        String instrumentId = HornSoundRegistry.getStandardHornSoundId(stack);
        if (instrumentId != null && (soundEventId = INSTRUMENT_TO_SOUND.get(instrumentId)) != null) {
            return class_2960.method_12829((String)soundEventId);
        }
        return null;
    }

    private static String getHornSoundId(class_1799 stack) {
        if (stack.method_7909() instanceof CooperHorn) {
            int soundIndex = CooperHorn.getSoundIndex(stack);
            return HornSoundRegistry.getCopperHornSoundId(soundIndex);
        }
        class_10710 instrumentComponent = (class_10710)stack.method_58694(class_9334.field_49612);
        if (instrumentComponent != null) {
            return HornSoundRegistry.getStandardHornSoundId(stack);
        }
        return null;
    }

    private static String getCopperHornSoundId(int index) {
        return switch (index) {
            case 0 -> "goatexpansion:copper_horn.memory";
            case 1 -> "goatexpansion:copper_horn.resting";
            case 2 -> "goatexpansion:copper_horn.thought";
            default -> null;
        };
    }

    private static String getStandardHornSoundId(class_1799 stack) {
        Optional hornKeyOptional;
        class_10710 component = (class_10710)stack.method_58694(class_9334.field_49612);
        if (component != null && (hornKeyOptional = component.comp_3598().method_67385()).isPresent()) {
            return ((class_5321)hornKeyOptional.get()).method_29177().toString();
        }
        return null;
    }

    static {
        HornSoundRegistry.registerHorn("minecraft:ponder_goat_horn", 50);
        HornSoundRegistry.registerHorn("minecraft:sing_goat_horn", 35);
        HornSoundRegistry.registerHorn("minecraft:seek_goat_horn", 80);
        HornSoundRegistry.registerHorn("minecraft:feel_goat_horn", 90);
        HornSoundRegistry.registerHorn("minecraft:admire_goat_horn", 60);
        HornSoundRegistry.registerHorn("minecraft:call_goat_horn", 115);
        HornSoundRegistry.registerHorn("minecraft:yearn_goat_horn", 115);
        HornSoundRegistry.registerHorn("minecraft:dream_goat_horn", 70);
        HornSoundRegistry.registerHorn("goatexpansion:copper_horn.memory", 85);
        HornSoundRegistry.registerHorn("goatexpansion:copper_horn.resting", 90);
        HornSoundRegistry.registerHorn("goatexpansion:copper_horn.thought", 90);
        INSTRUMENT_TO_SOUND.put("minecraft:ponder_goat_horn", "minecraft:item.goat_horn.sound.0");
        INSTRUMENT_TO_SOUND.put("minecraft:sing_goat_horn", "minecraft:item.goat_horn.sound.1");
        INSTRUMENT_TO_SOUND.put("minecraft:seek_goat_horn", "minecraft:item.goat_horn.sound.2");
        INSTRUMENT_TO_SOUND.put("minecraft:feel_goat_horn", "minecraft:item.goat_horn.sound.3");
        INSTRUMENT_TO_SOUND.put("minecraft:admire_goat_horn", "minecraft:item.goat_horn.sound.4");
        INSTRUMENT_TO_SOUND.put("minecraft:call_goat_horn", "minecraft:item.goat_horn.sound.5");
        INSTRUMENT_TO_SOUND.put("minecraft:yearn_goat_horn", "minecraft:item.goat_horn.sound.6");
        INSTRUMENT_TO_SOUND.put("minecraft:dream_goat_horn", "minecraft:item.goat_horn.sound.7");
    }
}

