/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.sensible_stackables;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import me.pajic.sensible_stackables.ModConfig;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="sensible_stackables")
@EventBusSubscriber(modid="sensible_stackables")
public class Main {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Sensible Stackables");
    private static final boolean DEBUG = !FMLLoader.getCurrent().isProduction();
    public static NumberFormat FORMATTER;

    public Main() {
        FORMATTER = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
        FORMATTER.setParseIntegerOnly(true);
        FORMATTER.setRoundingMode(RoundingMode.DOWN);
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        Main.debugLog("Applying stack sizes", new Object[0]);
        Main.patchItems((HolderLookup.RegistryLookup<Item>)event.getLookupProvider().lookupOrThrow(Registries.ITEM));
    }

    private static void patchItems(HolderLookup.RegistryLookup<Item> registry) {
        ModConfig.CONFIG.items().forEach((s, i) -> {
            if (s.startsWith("#")) {
                ResourceLocation rl = ResourceLocation.tryParse((String)s.substring(1));
                if (rl != null) {
                    registry.get(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl)).ifPresent(holders -> holders.forEach(itemHolder -> Main.patchItem((Item)itemHolder.value(), i)));
                } else {
                    LOGGER.error("Item tag {} not found", s);
                }
            } else {
                ResourceLocation rl = ResourceLocation.tryParse((String)s);
                if (rl != null) {
                    registry.get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl)).ifPresent(item -> Main.patchItem((Item)item.value(), i));
                } else {
                    LOGGER.error("Item {} not found", s);
                }
            }
        });
    }

    private static void patchItem(Item item, int i) {
        if (!item.components.has(DataComponents.MAX_DAMAGE) && i != (Integer)item.components.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1)) {
            int stackSize = Mth.clamp((int)i, (int)1, (int)(ModConfig.CONFIG.uncapStackSize() ? Integer.MAX_VALUE : 64));
            item.components = PatchedDataComponentMap.fromPatch((DataComponentMap)item.components, (DataComponentPatch)DataComponentPatch.builder().set(DataComponents.MAX_STACK_SIZE, (Object)stackSize).build());
            Main.debugLog("Set stack size for {} to {}", item.getDescriptionId(), stackSize);
        }
    }

    public static void debugLog(String message, Object ... args) {
        if (DEBUG) {
            LOGGER.info(message, args);
        }
    }
}

