package me.pajic.sensible_stackables.platform.neoforge;

//? neoforge {

import me.pajic.sensible_stackables.platform.Platform;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

import java.nio.file.Path;

public class NeoforgePlatform implements Platform {

	@Override
	public boolean isModLoaded(String modId) {
		return ModList.get().isLoaded(modId);
	}

	@Override
	public ModLoader loader() {
		return ModLoader.NEOFORGE;
	}

	@Override
	public String mcVersion() {
		return FMLLoader/*? if 1.21.1 {*/.versionInfo()/*?} else {*//*.getCurrent().getVersionInfo()*//*?}*/.mcVersion();
	}

	@Override
	public Path configDir() {
		return FMLPaths.CONFIGDIR.get();
	}

	@Override
	public boolean isDebug() {
		return !FMLLoader/*? if > 1.21.1 {*//*.getCurrent()*//*?}*/.isProduction();
	}
}
//?}
