/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.sensible_stackables;

import java.util.HashMap;
import java.util.Map;
import me.pajic.sensible_stackables.ModConfig;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="sensible_stackables")
public class Main {
    public static final String MOD_ID = "sensible_stackables";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sensible Stackables");
    private static final boolean DEBUG = !FMLLoader.isProduction();

    public Main(IEventBus modEventBus) {
        modEventBus.addListener(this::registerPayload);
    }

    public static void patchItems(Level level) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.ITEM);
        ModConfig.CONFIG.items().forEach((s, i) -> {
            if (s.startsWith("#")) {
                ResourceLocation rl = ResourceLocation.tryParse((String)s.substring(1));
                if (rl != null) {
                    registry.getTagOrEmpty(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl)).forEach(itemHolder -> Main.patchItem((Item)itemHolder.value(), i));
                } else {
                    LOGGER.error("Item tag {} not found", s);
                }
            } else {
                ResourceLocation rl = ResourceLocation.tryParse((String)s);
                if (rl != null) {
                    registry.getOptional(rl).ifPresent(item -> Main.patchItem(item, i));
                } else {
                    LOGGER.error("Item {} not found", s);
                }
            }
        });
    }

    private static void patchItem(Item item, int i) {
        if (!item.components.has(DataComponents.MAX_DAMAGE)) {
            int stackSize = Mth.clamp((int)i, (int)1, (int)(ModConfig.CONFIG.uncapStackSize() ? Integer.MAX_VALUE : 64));
            item.components = PatchedDataComponentMap.fromPatch((DataComponentMap)item.components, (DataComponentPatch)DataComponentPatch.builder().set(DataComponents.MAX_STACK_SIZE, (Object)stackSize).build());
            Main.debugLog("Set stack size for {} to {}", item.getDescriptionId(), stackSize);
        }
    }

    @SubscribeEvent
    public void registerPayload(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(S2CSyncConfigPayload.TYPE, S2CSyncConfigPayload.CODEC, (payload, context) -> {
            Main.debugLog("Applying stack sizes received from server", new Object[0]);
            ModConfig.CONFIG = new ModConfig.Config(payload.items(), payload.splashPotionCooldown(), payload.uncapStackSize());
            Main.patchItems(context.player().level());
        });
    }

    public static ResourceLocation withModNamespace(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void debugLog(String message, Object ... args) {
        if (DEBUG) {
            LOGGER.info(message, args);
        }
    }

    public record S2CSyncConfigPayload(Map<String, Integer> items, int splashPotionCooldown, boolean uncapStackSize) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<S2CSyncConfigPayload> TYPE = new CustomPacketPayload.Type(Main.withModNamespace("sync_config"));
        public static final StreamCodec<RegistryFriendlyByteBuf, S2CSyncConfigPayload> CODEC = CustomPacketPayload.codec(S2CSyncConfigPayload::write, S2CSyncConfigPayload::new);

        private S2CSyncConfigPayload(RegistryFriendlyByteBuf buf) {
            this(buf.readMap(HashMap::new, FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt), buf.readInt(), buf.readBoolean());
        }

        private void write(RegistryFriendlyByteBuf buf) {
            buf.writeMap(this.items, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
            buf.writeInt(this.splashPotionCooldown);
            buf.writeBoolean(this.uncapStackSize);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

