/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.sensible_stackables;

import java.util.HashMap;
import java.util.Map;
import me.pajic.sensible_stackables.ModConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ModInitializer {
    public static final String MOD_ID = "sensible_stackables";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sensible Stackables");
    private static final boolean DEBUG = FabricLoader.getInstance().isDevelopmentEnvironment();

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(S2CSyncConfigPayload.TYPE, S2CSyncConfigPayload.CODEC);
        ServerPlayerEvents.JOIN.register(player -> {
            Main.debugLog("Sending stack size data to player {}", player.method_5477().getString());
            ServerPlayNetworking.send((class_3222)player, (class_8710)new S2CSyncConfigPayload(ModConfig.CONFIG.items(), ModConfig.CONFIG.splashPotionCooldown(), ModConfig.CONFIG.uncapStackSize()));
        });
    }

    public static void patchItems(class_1937 level) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41197);
        ModConfig.CONFIG.items().forEach((s, i) -> {
            if (s.startsWith("#")) {
                class_2960 rl = class_2960.method_12829((String)s.substring(1));
                if (rl != null) {
                    registry.method_40286(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)rl)).forEach(itemHolder -> Main.patchItem((class_1792)itemHolder.comp_349(), i));
                } else {
                    LOGGER.error("Item tag {} not found", s);
                }
            } else {
                class_2960 rl = class_2960.method_12829((String)s);
                if (rl != null) {
                    registry.method_17966(rl).ifPresent(item -> Main.patchItem(item, i));
                } else {
                    LOGGER.error("Item {} not found", s);
                }
            }
        });
    }

    private static void patchItem(class_1792 item, int i) {
        if (!item.field_49263.method_57832(class_9334.field_50072)) {
            int stackSize = class_3532.method_15340((int)i, (int)1, (int)(ModConfig.CONFIG.uncapStackSize() ? Integer.MAX_VALUE : 64));
            item.field_49263 = class_9335.method_57935((class_9323)item.field_49263, (class_9326)class_9326.method_57841().method_57854(class_9334.field_50071, (Object)stackSize).method_57852());
            Main.debugLog("Set stack size for {} to {}", item.method_7876(), stackSize);
        }
    }

    public static class_2960 withModNamespace(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void debugLog(String message, Object ... args) {
        if (DEBUG) {
            LOGGER.info(message, args);
        }
    }

    public record S2CSyncConfigPayload(Map<String, Integer> items, int splashPotionCooldown, boolean uncapStackSize) implements class_8710
    {
        public static final class_8710.class_9154<S2CSyncConfigPayload> TYPE = new class_8710.class_9154(Main.withModNamespace("sync_config"));
        public static final class_9139<class_9129, S2CSyncConfigPayload> CODEC = class_8710.method_56484(S2CSyncConfigPayload::write, S2CSyncConfigPayload::new);

        private S2CSyncConfigPayload(class_9129 buf) {
            this(buf.method_34069(HashMap::new, class_2540::method_19772, class_2540::readInt), buf.readInt(), buf.readBoolean());
        }

        private void write(class_9129 buf) {
            buf.method_34063(this.items, class_2540::method_10814, class_2540::method_53002);
            buf.method_53002(this.splashPotionCooldown);
            buf.method_52964(this.uncapStackSize);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

