/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.sensible_stackables;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import me.pajic.sensible_stackables.ModConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Sensible Stackables");
    private static final boolean DEBUG = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static NumberFormat FORMATTER;

    public void onInitialize() {
        FORMATTER = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
        FORMATTER.setParseIntegerOnly(true);
        FORMATTER.setRoundingMode(RoundingMode.DOWN);
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            Main.debugLog("Applying stack sizes", new Object[0]);
            Main.patchItems(registries);
        });
    }

    private static void patchItems(class_5455 registryAccess) {
        class_2378 registry = registryAccess.method_30530(class_7924.field_41197);
        ModConfig.CONFIG.items().forEach((s, i) -> {
            if (s.startsWith("#")) {
                class_2960 rl = class_2960.method_12829((String)s.substring(1));
                if (rl != null) {
                    registry.method_40286(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)rl)).forEach(itemHolder -> Main.patchItem((class_1792)itemHolder.comp_349(), i));
                } else {
                    LOGGER.error("Item tag {} not found", s);
                }
            } else {
                class_2960 rl = class_2960.method_12829((String)s);
                if (rl != null) {
                    registry.method_17966(rl).ifPresent(item -> Main.patchItem(item, i));
                } else {
                    LOGGER.error("Item {} not found", s);
                }
            }
        });
    }

    private static void patchItem(class_1792 item, int i) {
        if (!item.field_49263.method_57832(class_9334.field_50072) && i != (Integer)item.field_49263.method_57830(class_9334.field_50071, (Object)1)) {
            int stackSize = class_3532.method_15340((int)i, (int)1, (int)(ModConfig.CONFIG.uncapStackSize() ? Integer.MAX_VALUE : 64));
            item.field_49263 = class_9335.method_57935((class_9323)item.field_49263, (class_9326)class_9326.method_57841().method_57854(class_9334.field_50071, (Object)stackSize).method_57852());
            Main.debugLog("Set stack size for {} to {}", item.method_7876(), stackSize);
        }
    }

    public static void debugLog(String message, Object ... args) {
        if (DEBUG) {
            LOGGER.info(message, args);
        }
    }
}

