package me.pajic.sensible_stackables;

import me.pajic.sensible_stackables.config.ModConfig;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public class Patcher {

	public static void patchItems(class_7225.class_7874 provider) {
		SensibleStackables.debugLog("Applying stack sizes");
		class_7225<class_1792> registry = provider.method_46762(class_7924.field_41197);
		ModConfig.CONFIG.items().forEach((s, i) -> {
			if (s.startsWith("#")) {
				class_2960 rl = class_2960.method_12829(s.substring(1));
				if (rl != null) registry.method_46733(class_6862.method_40092(class_7924.field_41197, rl)).ifPresent(item ->
						item.forEach(itemHolder -> patchItem(itemHolder.comp_349(), i))
				);
				else SensibleStackables.LOGGER.error("Item tag {} not found", s);
			} else {
				class_2960 rl = class_2960.method_12829(s);
				if (rl != null) registry.method_46746(class_5321.method_29179(class_7924.field_41197, rl)).ifPresent(item -> patchItem(item.comp_349(), i));
				else SensibleStackables.LOGGER.error("Item {} not found", s);
			}
		});
	}

	private static void patchItem(class_1792 item, int i) {
		if (!item.field_49263.method_57832(class_9334.field_50072) && i != item.field_49263.method_58695(class_9334.field_50071, 1)) {
			int stackSize = class_3532.method_15340(i, 1, ModConfig.CONFIG.uncapStackSize() ? Integer.MAX_VALUE : 64);
			item.field_49263 = class_9335.method_57935(
					item.field_49263,
					class_9326.method_57841().method_57854(class_9334.field_50071, stackSize).method_57852()
			);
			SensibleStackables.debugLog("Set stack size for {} to {}", item.method_7876(), stackSize);
		}
	}
}
