package me.pajic.sensible_stackables.mixin.stack_uncapper;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.sensible_stackables.config.ModConfig;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1542.class)
public class ItemEntityMixin {

    /**
     * @reason Allows item entity merging to merge more than 64 items at once.
     */
    @ModifyExpressionValue(
            method = "merge(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V",
            at = @At(
                    value = "CONSTANT",
                    args = "intValue=64"
            )
    )
    private static int uncapMergeSize(int original, @Local(ordinal = 1, argsOnly = true) class_1799 originStack) {
        return ModConfig.CONFIG.uncapStackSize() ? originStack.method_7914() : original;
    }
}
