/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.managers;

import dev.funa.headsChat.HeadsChat;
import dev.funa.headsChat.managers.configs.V2Migrator;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final HeadsChat plugin;
    public static int version = 2;
    private FileConfiguration config;
    public String chatFormatString;
    public String joinFormatString;
    public String leaveFormatString;

    public ConfigManager(HeadsChat plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        File file;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!(file = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        if (this.config.getInt("config-version", version) < 2) {
            this.plugin.getLogger().info("Old config version detected, migrating to v2...");
            V2Migrator.migrate(this.config);
            this.config.set("config-version", (Object)version);
            this.saveConfig();
            this.plugin.getLogger().info("Config migration complete.");
        }
        this.chatFormatString = this.config.getString("format.chat");
        this.joinFormatString = this.config.getString("format.join");
        this.leaveFormatString = this.config.getString("format.leave");
        this.plugin.getLogger().info("Config loaded!" + this.chatFormatString);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public Boolean isJoinFormatingEnabled() {
        return this.config.getBoolean("join.enabled");
    }

    public Boolean isLeaveFormatingEnabled() {
        return this.config.getBoolean("leave.enabled");
    }

    public Boolean logMessages() {
        return this.config.getBoolean("chat.logging");
    }

    public void saveConfig() {
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "config.yml"));
    }
}

