/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.chatHeads;

import dev.funa.chatHeads.ChatHeads;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final ChatHeads plugin;
    private FileConfiguration config;

    public ConfigManager(ChatHeads plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        File file;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!(file = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.plugin.getLogger().info("Config loaded!" + this.config.getString("message"));
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "config.yml"));
    }
}

