/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.commands;

import dev.funa.headsChat.HeadsChat;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final HeadsChat plugin;
    private final HashMap<UUID, Component> customNames = new HashMap();

    public MainCommand(@NotNull HeadsChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            Component help = MiniMessage.miniMessage().deserialize((Object)"  <#f6da71>\u029c\u1d07\u1d00\u1d05\u0455\u1d04\u029c\u1d00\u1d1b</#f6da71> <gray>\u2022</gray> <#f6da71>v{version}</#f6da71>\n\n  <#f6da71>/headschat reload</#f6da71><gray>:</gray> <white>Reload the config file.</white>\n\n  <#f6da71> </#f6da71>\n  <#718df6>\u1d04\u0280\u1d07\u1d00\u1d1b\u1d07\u1d05 \u0299\u028f \u0493\u1d1c\u0274\u1d00\u0455\u026a\u1d1b\u026a\u1d07\u0274 - @\u0493\u1d1c\u0274\u1d00\u0455\u026a\u1d1b\u026a\u1d07\u0274</#718df6>\n".replace("{version}", HeadsChat.version));
            sender.sendMessage(help);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("headschat.reload") || sender.isOp()) {
                this.plugin.reloadConfigFile();
                Component reloaded = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "Configuration reloaded."));
                sender.sendMessage(reloaded);
            } else {
                Component noPerm = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>You do not have permission to execute this command.</#ff5555>"));
                sender.sendMessage(noPerm);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("rename")) {
            if (!(sender instanceof Player)) {
                Component onlyPlayers = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>Only players can execute this command.</#ff5555>"));
                sender.sendMessage(onlyPlayers);
                return true;
            }
            Player p = (Player)sender;
            if (p.hasPermission("headschat.rename") || p.isOp()) {
                if (args.length < 2) {
                    Dialog dialog = Dialog.create(builder -> {
                        Component nameInputComponent;
                        String nameInputText = this.plugin.getConfigManager().getRenameDialogPrompt();
                        try {
                            nameInputComponent = MiniMessage.miniMessage().deserialize((Object)nameInputText);
                        }
                        catch (Exception e) {
                            nameInputComponent = Component.text((String)"Enter your new display name");
                        }
                        DialogAction.CustomClickAction confirmAction = DialogAction.customClick((view, audience) -> {
                            String newname = view.getText("name");
                            if (newname == null) {
                                return;
                            }
                            if (audience instanceof Player) {
                                Player player = (Player)audience;
                                Component cname = MiniMessage.miniMessage().deserialize((Object)newname);
                                player.displayName(cname);
                                player.playerListName(cname);
                                this.customNames.put(player.getUniqueId(), cname);
                                Component renamed = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "Your display name has been changed to <#71f678>" + newname + "</#71f678>."));
                                player.sendMessage(renamed);
                            }
                        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).build()));
                        ActionButton confirmButton = ActionButton.create((Component)Component.text((String)this.plugin.getConfigManager().getRenameDialogConfirm()), (Component)Component.text((String)this.plugin.getConfigManager().getRenameDialogConfirmTooltip()), (int)100, (DialogAction)confirmAction);
                        ActionButton discardButton = ActionButton.create((Component)Component.text((String)this.plugin.getConfigManager().getRenameDialogCancel()), (Component)Component.text((String)this.plugin.getConfigManager().getRenameDialogCancelTooltip()), (int)100, null);
                        ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)this.plugin.getConfigManager().getRenameDialogName())).inputs(List.of(DialogInput.text((String)"name", (Component)nameInputComponent).initial((String)MiniMessage.miniMessage().serialize(Objects.requireNonNull(p.displayName()))).width(300).build())).build()).type((DialogType)DialogType.confirmation((ActionButton)confirmButton, (ActionButton)discardButton));
                    });
                    p.showDialog((DialogLike)dialog);
                    return true;
                }
                String name = args[1];
                Component cname = MiniMessage.miniMessage().deserialize((Object)name);
                p.displayName(cname);
                p.playerListName(cname);
                this.customNames.put(p.getUniqueId(), cname);
                Component renamed = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "Your display name has been changed to <#71f678>" + name + "</#71f678>."));
                p.sendMessage(renamed);
            } else {
                Component noPerm = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>You do not have permission to execute this command.</#ff5555>"));
                p.sendMessage(noPerm);
            }
            return true;
        }
        Component unknown = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>Unknown subcommand. Use /headschat for help.</#ff5555>"));
        sender.sendMessage(unknown);
        return true;
    }

    @Nullable
    public Component getCustomName(@NotNull Player player) {
        return this.customNames.get(player.getUniqueId());
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        return List.of("reload", "rename");
    }
}

