/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.commands;

import dev.funa.headsChat.HeadsChat;
import dev.funa.headsChat.utils.Formatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final HeadsChat plugin;
    private final HashMap<Player, Player> lastMessaged = new HashMap();

    public MessageCommand(@NotNull HeadsChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        String message;
        Player target;
        if (args.length == 0) {
            Component reloaded = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "Configuration reloaded."));
            sender.sendMessage(reloaded);
            return true;
        }
        if (!(sender instanceof Player)) {
            Component onlyPlayers = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>Only players can use this command.</#ff5555>"));
            sender.sendMessage(onlyPlayers);
            return true;
        }
        Player p = (Player)sender;
        if (args.length > 1) {
            target = Bukkit.getPlayerExact((String)args[0]);
            if (target != null) {
                message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            } else {
                target = this.lastMessaged.get(p);
                message = String.join((CharSequence)" ", args);
            }
        } else {
            target = this.lastMessaged.get(p);
            message = String.join((CharSequence)" ", args);
        }
        if (target == null) {
            Component noRecipient = MiniMessage.miniMessage().deserialize((Object)(HeadsChat.prefix + "<#ff5555>You need to specify a player to message or have a conversation started.</#ff5555>"));
            sender.sendMessage(noRecipient);
            return true;
        }
        this.lastMessaged.put(p, target);
        String content = this.plugin.getConfigManager().dmFormatString.replace("{message}", message).replace("{target}", target.getPlayerListName()).replace("{target_head}", "<head:" + p.getName() + ">");
        Component full = Formatter.parseText(content, p, this.plugin);
        target.sendMessage(full);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
    }
}

