/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.listeners;

import dev.funa.headsChat.HeadsChat;
import dev.funa.headsChat.enums.ChatColorPermission;
import dev.funa.headsChat.utils.Formatter;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final HeadsChat plugin;
    private static final Pattern COLOR_PATTERN = Pattern.compile("&([0-9a-fk-or])", 2);
    private HashMap<UUID, Long> lastMessageTimestamps = new HashMap();

    public ChatListener(HeadsChat plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.lastMessageTimestamps.containsKey(event.getPlayer().getUniqueId())) {
            long cooldown;
            long lastTimestamp = this.lastMessageTimestamps.get(event.getPlayer().getUniqueId());
            long currentTimestamp = System.currentTimeMillis();
            if (currentTimestamp - lastTimestamp < (cooldown = (long)this.plugin.getConfigManager().getCooldownSeconds()) && !event.getPlayer().hasPermission(this.plugin.getConfigManager().getCooldownPermission())) {
                event.setCancelled(true);
                long timeLeft = (cooldown - (currentTimestamp - lastTimestamp)) / 1000L;
                String msg = this.plugin.getConfigManager().getCooldownMessage().replace("{time}", String.valueOf(timeLeft));
                Component cooldownMessage = Formatter.parseText(msg, event.getPlayer(), this.plugin);
                event.getPlayer().sendMessage(cooldownMessage);
                return;
            }
        }
        event.setCancelled(true);
        this.lastMessageTimestamps.replace(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        Player player = event.getPlayer();
        String content = this.plugin.getConfigManager().chatFormatString.replace("{message}", event.getMessage());
        Component full = Formatter.parseText(content, player, this.plugin);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.hasPermission("headschat.muted") && !p.isOp()) continue;
            p.sendMessage(full);
            if (!full.contains(p.playerListName())) continue;
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        }
        if (this.plugin.getConfigManager().logMessages().booleanValue()) {
            this.plugin.getLogger().info(player.getName() + ": " + event.getMessage());
        }
    }

    private String applyColorPermissions(Player player, String input) {
        Matcher matcher = COLOR_PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            char code = Character.toLowerCase(matcher.group(1).charAt(0));
            if (ChatColorPermission.canUse(player, code)) {
                matcher.appendReplacement(sb, "\u00a7" + code);
                continue;
            }
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

