/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.listeners;

import dev.funa.headsChat.HeadsChat;
import dev.funa.headsChat.utils.Formatter;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinLeaveListener
implements Listener {
    private final HeadsChat plugin;

    public JoinLeaveListener(HeadsChat plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.plugin.getConfigManager().isRenameEnabled()) {
            Player p = event.getPlayer();
            Component customName = this.plugin.mainCommandExecutor.getCustomName(p);
            p.displayName(customName);
            p.playerListName(customName);
        }
        if (this.plugin.getConfigManager().isJoinFormatingEnabled().booleanValue()) {
            event.setJoinMessage(null);
            Component full = Formatter.parseText(this.plugin.getConfigManager().joinFormatString, event.getPlayer(), this.plugin);
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.hasPermission("headschat.muted")) continue;
                p.sendMessage(full);
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        if (this.plugin.getConfigManager().isLeaveFormatingEnabled().booleanValue()) {
            event.setQuitMessage(null);
            Component full = Formatter.parseText(this.plugin.getConfigManager().leaveFormatString, event.getPlayer(), this.plugin);
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.hasPermission("headschat.muted")) continue;
                p.sendMessage(full);
            }
        }
    }
}

