/*
 * Decompiled with CFR 0.152.
 */
package dev.funa.headsChat.managers;

import dev.funa.headsChat.HeadsChat;
import dev.funa.headsChat.managers.configs.VXMigrator;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final HeadsChat plugin;
    public static int version = 3;
    private FileConfiguration config;
    public String chatFormatString;
    public String joinFormatString;
    public String leaveFormatString;
    public String dmFormatString;

    public ConfigManager(HeadsChat plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        File file;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!(file = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        for (int i = this.config.getInt("config-version", 1); i < version; ++i) {
            this.plugin.getLogger().info("Migrating config from v" + i + " to v" + (i + 1) + "...");
            VXMigrator.migrate(i + 1, this.config);
            this.config.set("config-version", (Object)(i + 1));
            this.plugin.getLogger().info("Config migration to " + (i + 1) + " complete.");
            this.saveConfig();
        }
        this.chatFormatString = this.config.getString("chat.format");
        this.joinFormatString = this.config.getString("join.format");
        this.leaveFormatString = this.config.getString("leave.format");
        this.dmFormatString = this.config.getString("dm.format");
        this.plugin.getLogger().info("Config loaded!" + this.chatFormatString);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public Boolean isJoinFormatingEnabled() {
        return this.config.getBoolean("join.enabled");
    }

    public Boolean isLeaveFormatingEnabled() {
        return this.config.getBoolean("leave.enabled");
    }

    public Boolean logMessages() {
        return this.config.getBoolean("chat.logging");
    }

    public int getCooldownSeconds() {
        return this.config.getInt("chat.cooldown", 0);
    }

    public String getCooldownMessage() {
        return this.config.getString("chat.cooldown-message", "<red>You are on cooldown for {seconds} more seconds.");
    }

    public String getCooldownPermission() {
        return this.config.getString("chat.cooldown-bypass-permission", "headschat.bypass.cooldown");
    }

    public String getRenameDialogName() {
        return this.config.getString("nick.dialog.name", "Change your Display Name");
    }

    public String getRenameDialogConfirm() {
        return this.config.getString("nick.dialog.confirm", "Confirm");
    }

    public String getRenameDialogCancel() {
        return this.config.getString("nick.dialog.cancel", "Cancel");
    }

    public String getRenameDialogPrompt() {
        return this.config.getString("nick.dialog.prompt", "Choose a new name");
    }

    public String getRenameDialogCancelTooltip() {
        return this.config.getString("nick.dialog.cancel-tooltip", "Click to cancel changing your display name");
    }

    public String getRenameDialogConfirmTooltip() {
        return this.config.getString("nick.dialog.confirm-tooltip", "Click to confirm your new display name");
    }

    public void saveConfig() {
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "config.yml"));
    }

    public boolean isRenameEnabled() {
        return this.config.getBoolean("nick.enabled", true);
    }
}

