/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp;

import dev.norska.hexp.bukkit.Metrics;
import dev.norska.hexp.commands.HarvestEXPCommands;
import dev.norska.hexp.commands.HarvestEXPTabComplete;
import dev.norska.hexp.data.CropProfileHandler;
import dev.norska.hexp.folia.universalScheduler.UniversalScheduler;
import dev.norska.hexp.folia.universalScheduler.scheduling.schedulers.TaskScheduler;
import dev.norska.hexp.listeners.HEXPBlockBreak;
import dev.norska.hexp.listeners.HEXPBlockPlace;
import dev.norska.hexp.listeners.JoinUpdateNotifier;
import dev.norska.hexp.ndev.NorskaHandler;
import dev.norska.hexp.ndev.NorskaUtils;
import dev.norska.hexp.perms.HEXPPermHandler;
import dev.norska.hexp.utils.HEXPUtils;
import dev.norska.niridiumcolorapi.IridiumColorAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HarvestEXP
extends JavaPlugin {
    private static HarvestEXP instance;
    private NorskaHandler nHandler = new NorskaHandler();
    private NorskaUtils nUtils = new NorskaUtils();
    private CropProfileHandler cropProfileHandler = new CropProfileHandler();
    private HEXPUtils HEXPUtils = new HEXPUtils();
    private HEXPPermHandler permHandler = new HEXPPermHandler();
    public String prefix;
    public Boolean usingFolia;
    private static TaskScheduler scheduler;

    public HarvestEXP() {
        instance = this;
    }

    public static HarvestEXP getInstance() {
        return instance;
    }

    public void onEnable() {
        this.usingFolia = this.isFolia();
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        this.generateFiles();
        this.getPermHandler().loadPerms();
        this.cache();
        this.getNHandler().getMessageFeedbackHandler().loadConsoleMessages();
        this.prefix = Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19") || Bukkit.getVersion().contains("1.20") || Bukkit.getVersion().contains("1.21") ? IridiumColorAPI.process("&8[<GRADIENT:7EFF18>HarvestEXP</GRADIENT:FFF500>&8]") : IridiumColorAPI.process("&8[&aHarvestEXP&8]");
        this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP", this.prefix, this.getDescription().getVersion());
        this.fetchAliases();
        this.registerEvents();
        this.registerCommands();
        this.checkHooks();
        this.startMetricsService();
        this.getNHandler().getMessageFeedbackHandler().loadTextComponents(this);
        if (this.usingFolia.booleanValue()) {
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("FOLIA", this.prefix);
        }
        this.checkUpdates();
    }

    public void onDisable() {
        ArrayList<String> locationList = new ArrayList<String>();
        for (Location location : this.getHEXPUtils().getManuallyPlaced()) {
            String seralizedLocation = this.getHEXPUtils().serializeLocation(location);
            locationList.add(seralizedLocation);
        }
        this.getNHandler().getConfigurationHandler().getDataFile().set("locations", locationList);
        try {
            this.getNHandler().getConfigurationHandler().getDataFile().save(new File(this.getDataFolder() + File.separator + "data.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateFiles() {
        this.getNHandler().getConfigurationHandler().generateFiles(this);
    }

    public void cache() {
        this.getNHandler().getCacheHandler().cache(this);
    }

    private void checkUpdates() {
        this.getNHandler().getUpdateHandler().fetchVersionFromServer(this);
        this.getNHandler().getUpdateHandler().checkForUpdates(this);
    }

    private void checkHooks() {
        this.getNHandler().getHooksHandler().checkForHooks(this);
    }

    private void fetchAliases() {
        this.getNUtils().fetchAliases(this);
    }

    private void startMetricsService() {
        Metrics metrics = new Metrics(this, 13859);
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new HEXPBlockBreak(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HEXPBlockPlace(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinUpdateNotifier(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("harvestexp").setExecutor((CommandExecutor)new HarvestEXPCommands(this));
        this.getCommand("harvestexp").setTabCompleter((TabCompleter)new HarvestEXPTabComplete(this));
    }

    private boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public NorskaHandler getNHandler() {
        return this.nHandler;
    }

    public NorskaUtils getNUtils() {
        return this.nUtils;
    }

    public CropProfileHandler getCropProfileHandler() {
        return this.cropProfileHandler;
    }

    public HEXPUtils getHEXPUtils() {
        return this.HEXPUtils;
    }

    public HEXPPermHandler getPermHandler() {
        return this.permHandler;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }
}

