/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.listeners;

import dev.norska.hexp.HarvestEXP;
import dev.norska.hexp.api.HarvestEXPAPI;
import dev.norska.hexp.api.HarvestEXPEvent;
import dev.norska.hexp.data.CropProfile;
import dev.norska.hexp.ndev.debug.NDebug;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class HEXPBlockBreak
implements Listener {
    private HarvestEXP main;

    public HEXPBlockBreak(HarvestEXP main) {
        this.main = main;
    }

    @EventHandler
    public void onCropHarvest(BlockBreakEvent e) {
        boolean isBreakable;
        if (e.isCancelled()) {
            return;
        }
        if (!HarvestEXPAPI.isValidCrop(this.main, e.getBlock()).booleanValue()) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getBlock();
        CropProfile profile = HarvestEXPAPI.getCropProfile(this.main, b);
        boolean isInWorldBlacklist = profile.getWorldBlacklist().contains(p.getWorld().getName());
        boolean hasPermission = profile.getPermissionRequired() != false && !p.hasPermission(profile.getPermission());
        boolean bl = isBreakable = this.main.getHEXPUtils().checkIfBreakable(profile, b, p) == false;
        if (isInWorldBlacklist) {
            NDebug.message(p, "RETURN " + isInWorldBlacklist + " due to isInWorldBlacklist - HEXPBlockBreak for Block " + b.toString());
            return;
        }
        if (hasPermission) {
            NDebug.message(p, "RETURN " + hasPermission + " due to hasPermission - HEXPBlockBreak for Block " + b.toString());
            return;
        }
        if (isBreakable) {
            NDebug.message(p, "RETURN " + isBreakable + " due to isBreakable - HEXPBlockBreak for Block " + b.toString());
            return;
        }
        HarvestEXPEvent event = new HarvestEXPEvent(p, profile);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        profile = event.getCropProfile();
        if (profile.getDropOnBreak().booleanValue()) {
            e.setExpToDrop(profile.getExperienceAmount());
        } else {
            ((ExperienceOrb)p.getWorld().spawn(b.getLocation(), ExperienceOrb.class)).setExperience(profile.getExperienceAmount());
        }
        this.main.getNHandler().getMessageFeedbackHandler().sendMessage(this.main, (CommandSender)p, "EVENT_HARVEST_EXP_GAIN", Integer.toString(profile.getExperienceAmount()));
        this.main.getNHandler().getSoundFeedbackHandler().playSound(this.main, (CommandSender)p, "EVENT_HARVEST_EXP_GAIN");
        NDebug.message(p, "Awarded experience for breaking crop - HEXPBlockbreak for Block " + b.toString());
        if (this.main.getHEXPUtils().getManuallyPlaced().contains(b.getLocation())) {
            this.main.getHEXPUtils().getManuallyPlaced().remove(b.getLocation());
        }
    }
}

