/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.reflection.jvm;

import dev.norska.hexp.reflection.ReflectiveHandle;
import dev.norska.hexp.reflection.XAccessFlag;
import dev.norska.hexp.reflection.XReflection;
import dev.norska.hexp.reflection.jvm.FlaggedNamedMemberHandle;
import dev.norska.hexp.reflection.jvm.MemberHandle;
import dev.norska.hexp.reflection.jvm.classes.ClassHandle;
import dev.norska.hexp.reflection.jvm.objects.ReflectedObject;
import dev.norska.hexp.reflection.jvm.objects.ReflectedObjectHandle;
import dev.norska.hexp.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ConstructorMemberHandle
extends MemberHandle {
    protected ClassHandle[] parameterTypes = new ClassHandle[0];

    public ConstructorMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    @ApiStatus.Internal
    public ClassHandle[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ConstructorMemberHandle parameters(Class<?> ... parameterTypes) {
        this.parameterTypes = (ClassHandle[])Arrays.stream(parameterTypes).map(XReflection::of).toArray(ClassHandle[]::new);
        return this;
    }

    public ConstructorMemberHandle parameters(ClassHandle ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        if (this.accessFlags.contains((Object)XAccessFlag.FINAL)) {
            throw new UnsupportedOperationException("Constructor cannot be final: " + this);
        }
        if (this.accessFlags.contains((Object)XAccessFlag.PRIVATE)) {
            return this.clazz.getNamespace().getLookup().unreflectConstructor((Constructor<?>)this.reflectJvm());
        }
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        return this.clazz.getNamespace().getLookup().findConstructor((Class)this.clazz.unreflect(), MethodType.methodType(Void.TYPE, parameterTypes));
    }

    @Override
    public ConstructorMemberHandle signature(@Language(value="Java", suffix=";") String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseConstructor(this);
    }

    @Override
    @NotNull
    public ReflectiveHandle<ReflectedObject> jvm() {
        return new ReflectedObjectHandle(() -> ReflectedObject.of(this.reflectJvm()));
    }

    public Constructor<?> reflectJvm() throws ReflectiveOperationException {
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        return this.handleAccessible(((Class)this.clazz.unreflect()).getDeclaredConstructor(parameterTypes));
    }

    @Override
    public ConstructorMemberHandle copy() {
        ConstructorMemberHandle handle = new ConstructorMemberHandle(this.clazz);
        handle.parameterTypes = this.parameterTypes;
        handle.accessFlags.addAll(this.accessFlags);
        return handle;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        str = str + this.accessFlags.stream().map(x -> x.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
        str = str + this.clazz.toString() + ' ';
        str = str + '(' + Arrays.stream(this.parameterTypes).map(Object::toString).collect(Collectors.joining(", ")) + ')';
        return str + '}';
    }
}

