/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.reflection.jvm.classes;

import dev.norska.hexp.reflection.ReflectiveNamespace;
import dev.norska.hexp.reflection.jvm.classes.ClassHandle;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UnknownClassHandle
extends ClassHandle {
    private final String name;

    public UnknownClassHandle(ReflectiveNamespace namespace, String name) {
        super(namespace);
        this.name = name;
    }

    @Override
    public Set<String> getPossibleNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public UnknownClassHandle asArray(int dimensions) {
        return new UnknownClassHandle(this.namespace, this.name + "[]");
    }

    @Override
    public boolean isArray() {
        return this.name.endsWith("[]");
    }

    @Override
    public UnknownClassHandle copy() {
        return new UnknownClassHandle(this.namespace, this.name);
    }

    @Override
    @NotNull
    public Class<?> reflect() throws ReflectiveOperationException {
        throw new ReflectiveOperationException("Unknown class: " + this.name);
    }

    public String toString() {
        return "UnknownClassHandle(" + this.name + ')';
    }
}

