/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public final class CommentedConfiguration
extends YamlConfiguration {
    private final Map<String, String> configComments = new HashMap<String, String>();
    private boolean creationFailure = false;

    public CommentedConfiguration() {
        try {
            this.options().parseComments(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void syncWithConfig(File file, InputStream resource, String ... ignoredSections) throws IOException {
        if (this.creationFailure) {
            return;
        }
        CommentedConfiguration cfg = CommentedConfiguration.loadConfiguration(resource);
        if (this.syncConfigurationSection(cfg, cfg.getConfigurationSection(""), Arrays.asList(ignoredSections)) && file != null) {
            this.save(file);
        }
    }

    public void setComment(String path, String comment) {
        if (comment == null) {
            this.configComments.remove(path);
        } else {
            this.configComments.put(path, comment);
        }
    }

    public String getComment(String path) {
        return this.getComment(path, null);
    }

    public String getComment(String path, String def) {
        return this.configComments.getOrDefault(path, def);
    }

    public boolean containsComment(String path) {
        return this.getComment(path) != null;
    }

    public boolean hasFailed() {
        return this.creationFailure;
    }

    public void loadFromString(String contents) throws InvalidConfigurationException {
        super.loadFromString(contents);
        String[] lines = contents.split("\n");
        StringBuilder comments = new StringBuilder();
        String currentSection = "";
        for (int currentIndex = 0; currentIndex < lines.length; ++currentIndex) {
            if (CommentedConfiguration.isComment(lines[currentIndex])) {
                comments.append(lines[currentIndex]).append("\n");
                continue;
            }
            if (!CommentedConfiguration.isNewSection(lines[currentIndex])) continue;
            currentSection = CommentedConfiguration.getSectionPath(this, lines[currentIndex], currentSection);
            if (comments.length() > 1) {
                this.setComment(currentSection, comments.toString().substring(0, comments.length() - 1));
            }
            comments = new StringBuilder();
        }
    }

    public String saveToString() {
        this.options().header(null);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(super.saveToString().split("\n")));
        String currentSection = "";
        for (int currentIndex = 0; currentIndex < lines.size(); ++currentIndex) {
            String line = (String)lines.get(currentIndex);
            if (!CommentedConfiguration.isNewSection(line) || !this.containsComment(currentSection = CommentedConfiguration.getSectionPath(this, line, currentSection))) continue;
            lines.add(currentIndex, this.getComment(currentSection));
            ++currentIndex;
        }
        StringBuilder contents = new StringBuilder();
        for (String line : lines) {
            contents.append("\n").append(line);
        }
        return contents.length() == 0 ? "" : contents.substring(1);
    }

    private boolean syncConfigurationSection(CommentedConfiguration commentedConfig, ConfigurationSection section, List<String> ignoredSections) {
        boolean changed = false;
        for (String key : section.getKeys(false)) {
            String path;
            String string = path = section.getCurrentPath().isEmpty() ? key : section.getCurrentPath() + "." + key;
            if (section.isConfigurationSection(key)) {
                boolean isIgnored = ignoredSections.stream().anyMatch(path::contains);
                boolean containsSection = this.contains(path);
                if (!containsSection || !isIgnored) {
                    changed = this.syncConfigurationSection(commentedConfig, section.getConfigurationSection(key), ignoredSections) || changed;
                }
            } else if (!this.contains(path)) {
                this.set(path, section.get(key));
                changed = true;
            }
            if (!commentedConfig.containsComment(path) || commentedConfig.getComment(path).equals(this.getComment(path))) continue;
            this.setComment(path, commentedConfig.getComment(path));
            changed = true;
        }
        if (changed) {
            CommentedConfiguration.correctIndexes(section, this.getConfigurationSection(section.getCurrentPath()));
        }
        return changed;
    }

    private CommentedConfiguration flagAsFailed() {
        this.creationFailure = true;
        return this;
    }

    public static CommentedConfiguration loadConfiguration(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            return CommentedConfiguration.loadConfiguration(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException ex) {
            Bukkit.getLogger().warning("File " + file.getName() + " doesn't exist.");
            return new CommentedConfiguration().flagAsFailed();
        }
    }

    public static CommentedConfiguration loadConfiguration(InputStream inputStream) {
        return CommentedConfiguration.loadConfiguration(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static CommentedConfiguration loadConfiguration(Reader reader) {
        CommentedConfiguration config = new CommentedConfiguration();
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            StringBuilder contents = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                contents.append(line).append('\n');
            }
            config.loadFromString(contents.toString());
        }
        catch (IOException | InvalidConfigurationException ex) {
            config.flagAsFailed();
            ex.printStackTrace();
        }
        return config;
    }

    private static boolean isNewSection(String line) {
        String trimLine = line.trim();
        return trimLine.contains(": ") || trimLine.endsWith(":");
    }

    private static String getSectionPath(CommentedConfiguration commentedConfig, String line, String currentSection) {
        String newSection = line.trim().split(": ")[0];
        if (newSection.endsWith(":")) {
            newSection = newSection.substring(0, newSection.length() - 1);
        }
        if (newSection.startsWith(".")) {
            newSection = newSection.substring(1);
        }
        if (newSection.startsWith("'") && newSection.endsWith("'")) {
            newSection = newSection.substring(1, newSection.length() - 1);
        }
        if (!currentSection.isEmpty() && commentedConfig.contains(currentSection + "." + newSection)) {
            newSection = currentSection + "." + newSection;
        } else {
            String parentSection = currentSection;
            while (!parentSection.isEmpty() && !commentedConfig.contains((parentSection = CommentedConfiguration.getParentPath(parentSection)) + "." + newSection)) {
            }
            newSection = parentSection.trim().isEmpty() ? newSection : parentSection + "." + newSection;
        }
        return newSection;
    }

    private static boolean isComment(String line) {
        String trimLine = line.trim();
        return trimLine.startsWith("#") || trimLine.isEmpty();
    }

    private static String getParentPath(String path) {
        return path.contains(".") ? path.substring(0, path.lastIndexOf(46)) : "";
    }

    private static void correctIndexes(ConfigurationSection section, ConfigurationSection target) {
        List<Pair<String, Object>> sectionMap = CommentedConfiguration.getSectionMap(section);
        ArrayList<Pair<String, Object>> correctOrder = new ArrayList<Pair<String, Object>>();
        for (Pair<String, Object> entry : sectionMap) {
            correctOrder.add(new Pair<String, Object>((String)((Pair)entry).key, target.get((String)((Pair)entry).key)));
        }
        CommentedConfiguration.clearConfiguration(target);
        for (Pair<String, Object> entry : correctOrder) {
            target.set((String)((Pair)entry).key, ((Pair)entry).value);
        }
    }

    private static List<Pair<String, Object>> getSectionMap(ConfigurationSection section) {
        ArrayList<Pair<String, Object>> list = new ArrayList<Pair<String, Object>>();
        for (String key : section.getKeys(false)) {
            list.add(new Pair<String, Object>(key, section.get(key)));
        }
        return list;
    }

    private static void clearConfiguration(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            section.set(key, null);
        }
    }

    private static class Pair<K, V> {
        private final K key;
        private final V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Pair && this.key.equals(((Pair)obj).key) && this.value.equals(((Pair)obj).value);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

